/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.decoder;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import org.rcsb.mmtf.dataholders.MmtfStructure;
import org.rcsb.mmtf.serialization.MessagePackSerialization;

public class ReaderUtils {
    private static final int BYTE_BUFFER_CHUNK_SIZE = 4096;

    public static MmtfStructure getDataFromUrl(String pdbId) throws IOException {
        return ReaderUtils.getDataFromUrl(pdbId, false, false);
    }

    public static MmtfStructure getDataFromUrl(String pdbId, boolean https, boolean reduced) throws IOException {
        byte[] bytes = ReaderUtils.getByteArrayFromUrl(pdbId, https, reduced);
        MessagePackSerialization mmtfBeanSeDeMessagePackImpl = new MessagePackSerialization();
        return mmtfBeanSeDeMessagePackImpl.deserialize((InputStream)new ByteArrayInputStream(ReaderUtils.deflateGzip(bytes)));
    }

    public static byte[] getByteArrayFromUrl(String pdbId) throws IOException {
        return ReaderUtils.getByteArrayFromUrl(pdbId, false, false);
    }

    /*
     * Exception decompiling
     */
    public static byte[] getByteArrayFromUrl(String pdbId, boolean https, boolean reduced) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] deflateGzip(byte[] inputBytes) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(inputBytes));){
            int size;
            byte[] buffer = new byte[4096];
            while (gzipInputStream.available() == 1 && (size = gzipInputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, size);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static MmtfStructure getDataFromFile(Path filePath) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(ReaderUtils.readFile(filePath));){
            MmtfStructure mmtfStructure = ReaderUtils.getDataFromInputStream(is);
            return mmtfStructure;
        }
    }

    private static byte[] readFile(Path path) throws IOException {
        byte[] data = Files.readAllBytes(path);
        return data;
    }

    public static MmtfStructure getDataFromInputStream(InputStream inStream) throws IOException {
        if (!(inStream instanceof BufferedInputStream)) {
            inStream = new BufferedInputStream(inStream, 65536);
        }
        MessagePackSerialization mmtfBeanSeDeMessagePackImpl = new MessagePackSerialization();
        return mmtfBeanSeDeMessagePackImpl.deserialize(inStream);
    }
}

