/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.codec;

import org.rcsb.mmtf.codec.ArrayConverters;
import org.rcsb.mmtf.codec.CodecInterface;
import org.rcsb.mmtf.codec.IntCodecInterface;
import org.rcsb.mmtf.codec.OptionParser;
import org.rcsb.mmtf.decoder.ArrayDecoders;
import org.rcsb.mmtf.encoder.ArrayEncoders;

public enum IntCodecs implements IntCodecInterface,
CodecInterface
{
    RUN_LENGTH_DELTA(8, "Run length delta"){

        @Override
        public byte[] encode(int[] inputData, int param) {
            return ArrayConverters.convertIntegersToFourByte(ArrayEncoders.runlengthEncode(ArrayEncoders.deltaEncode(inputData)));
        }

        @Override
        public int[] decode(byte[] inputData, int param) {
            return ArrayDecoders.deltaDecode(ArrayDecoders.runlengthDecode(ArrayConverters.convertFourByteToIntegers(inputData)));
        }
    }
    ,
    CONVERT_4_BYTE(4, "Convert to bytes as 4 byte integers."){

        @Override
        public byte[] encode(int[] inputData, int param) {
            return ArrayConverters.convertIntegersToFourByte(inputData);
        }

        @Override
        public int[] decode(byte[] inputData, int param) {
            return ArrayConverters.convertFourByteToIntegers(inputData);
        }
    }
    ,
    CONVERT_BYTE(2, "Convert to bytes as  byte integers."){

        @Override
        public byte[] encode(int[] inputData, int param) {
            return ArrayConverters.convertIntegersToBytes(inputData);
        }

        @Override
        public int[] decode(byte[] inputData, int param) {
            return ArrayConverters.convertByteToIntegers(inputData);
        }
    };

    private final int codecId;
    private final String codecName;

    private IntCodecs(int codecId, String codecName) {
        this.codecId = codecId;
        this.codecName = codecName;
    }

    public static IntCodecs getCodec(int codecId) {
        for (IntCodecs codecs : IntCodecs.values()) {
            if (codecId != codecs.codecId) continue;
            return codecs;
        }
        throw new IllegalArgumentException(codecId + " not recognised as codec strategy.");
    }

    public static int[] decodeArr(byte[] inputData) {
        OptionParser optionParser = new OptionParser(inputData);
        IntCodecs codecs = IntCodecs.getCodec(optionParser.methodNumber);
        return codecs.decode(optionParser.data, optionParser.param);
    }

    @Override
    public String getCodecName() {
        return this.codecName;
    }

    @Override
    public int getCodecId() {
        return this.codecId;
    }
}

