/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.codec;

import org.rcsb.mmtf.codec.ArrayConverters;
import org.rcsb.mmtf.codec.CharCodecInterface;
import org.rcsb.mmtf.codec.CodecInterface;
import org.rcsb.mmtf.codec.OptionParser;
import org.rcsb.mmtf.decoder.ArrayDecoders;
import org.rcsb.mmtf.encoder.ArrayEncoders;

public enum CharCodecs implements CharCodecInterface,
CodecInterface
{
    RUN_LENGTH(6, "Run length"){

        @Override
        public byte[] encode(char[] inputData, int param) {
            return ArrayConverters.convertIntegersToFourByte(ArrayEncoders.runlengthEncode(ArrayConverters.convertCharToIntegers(inputData)));
        }

        @Override
        public char[] decode(byte[] inputData, int param) {
            return ArrayConverters.convertIntegerToChar(ArrayDecoders.runlengthDecode(ArrayConverters.convertFourByteToIntegers(inputData)));
        }
    };

    private final int codecId;
    private final String codecName;

    private CharCodecs(int inputId, String name) {
        this.codecId = inputId;
        this.codecName = name;
    }

    public static CharCodecs getCodec(int inputInt) {
        for (CharCodecs codecs : CharCodecs.values()) {
            if (inputInt != codecs.codecId) continue;
            return codecs;
        }
        throw new IllegalArgumentException(inputInt + " not recognised as codec strategy.");
    }

    public static char[] decodeArr(byte[] inputData) {
        OptionParser optionParser = new OptionParser(inputData);
        CharCodecs codecs = CharCodecs.getCodec(optionParser.methodNumber);
        return codecs.decode(optionParser.data, optionParser.param);
    }

    @Override
    public String getCodecName() {
        return this.codecName;
    }

    @Override
    public int getCodecId() {
        return this.codecId;
    }
}

