/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.encoder;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.rcsb.mmtf.api.StructureDataInterface;
import org.rcsb.mmtf.decoder.DecoderUtils;
import org.rcsb.mmtf.encoder.AdapterToStructureData;
import org.rcsb.mmtf.encoder.EncoderUtils;
import org.rcsb.mmtf.encoder.SummaryData;

public class ReducedEncoder
implements Serializable {
    private static final long serialVersionUID = -528732924956087110L;
    private static final String CALPHA_NAME = "CA";
    private static final String CARBON_ELEMENT = "C";
    private static final String PHOSPHATE_NAME = "P";
    private static final String PHOSPHATE_ELEMENT = "P";

    public static StructureDataInterface getReduced(StructureDataInterface full) {
        HashMap<Integer, Integer> atomMap = new HashMap<Integer, Integer>();
        Integer[] centerAtomIndices = ReducedEncoder.getCenterAtomGroupIndices(full);
        AdapterToStructureData reduced = new AdapterToStructureData();
        reduced.setMmtfProducer(full.getMmtfProducer());
        SummaryData dataSummary = ReducedEncoder.getDataSummaryData(full, centerAtomIndices);
        reduced.initStructure(dataSummary.numBonds, dataSummary.numAtoms, dataSummary.numGroups, dataSummary.numChains, full.getNumModels(), full.getStructureId());
        DecoderUtils.addXtalographicInfo(full, reduced);
        DecoderUtils.addHeaderInfo(full, reduced);
        DecoderUtils.generateBioAssembly(full, reduced);
        DecoderUtils.addEntityInfo(full, reduced);
        int atomCount = 0;
        int groupCount = 0;
        int chainCount = 0;
        int reducedAtomCount = -1;
        for (int i = 0; i < full.getNumModels(); ++i) {
            int numChains = full.getChainsPerModel()[i];
            reduced.setModelInfo(i, numChains);
            int j = 0;
            while (j < numChains) {
                String chainType = EncoderUtils.getTypeFromChainId(full, chainCount);
                int reducedGroupsPerChain = 0;
                int k = 0;
                while (k < full.getGroupsPerChain()[chainCount]) {
                    int groupType = full.getGroupTypeIndices()[groupCount];
                    Set<Integer> atomIndicesToAdd = ReducedEncoder.getIndicesToAdd(full, groupType, chainType, centerAtomIndices);
                    int bondsToAdd = ReducedEncoder.getNumIntraGroupBonds(atomIndicesToAdd, full, groupType, centerAtomIndices);
                    if (atomIndicesToAdd.size() > 0) {
                        reduced.setGroupInfo(full.getGroupName(groupType), full.getGroupIds()[groupCount], full.getInsCodes()[groupCount], full.getGroupChemCompType(groupType), atomIndicesToAdd.size(), bondsToAdd, full.getGroupSingleLetterCode(groupType), full.getGroupSequenceIndices()[groupCount], full.getSecStructList()[groupCount]);
                        ++reducedGroupsPerChain;
                    }
                    int l = 0;
                    while (l < full.getNumAtomsInGroup(groupType)) {
                        if (atomIndicesToAdd.contains(l)) {
                            atomMap.put(atomCount, ++reducedAtomCount);
                            reduced.setAtomInfo(full.getGroupAtomNames(groupType)[l], full.getAtomIds()[atomCount], full.getAltLocIds()[atomCount], full.getxCoords()[atomCount], full.getyCoords()[atomCount], full.getzCoords()[atomCount], full.getOccupancies()[atomCount], full.getbFactors()[atomCount], full.getGroupElementNames(groupType)[l], full.getGroupAtomCharges(groupType)[l]);
                        }
                        ++l;
                        ++atomCount;
                    }
                    if (bondsToAdd > 0) {
                        for (l = 0; l < full.getGroupBondOrders(groupType).length; ++l) {
                            int index1 = full.getGroupBondIndices(groupType)[l * 2];
                            int index2 = full.getGroupBondIndices(groupType)[l * 2 + 1];
                            int bondOrder = full.getGroupBondOrders(groupType)[l];
                            reduced.setGroupBond(index1, index2, bondOrder);
                        }
                    }
                    ++k;
                    ++groupCount;
                }
                reduced.setChainInfo(full.getChainIds()[chainCount], full.getChainNames()[chainCount], reducedGroupsPerChain);
                ++j;
                ++chainCount;
            }
        }
        ReducedEncoder.addInterGroupBonds(full, reduced, atomMap);
        reduced.finalizeStructure();
        return reduced;
    }

    private static void addInterGroupBonds(StructureDataInterface full, AdapterToStructureData reduced, Map<Integer, Integer> atomMap) {
        for (int i = 0; i < full.getInterGroupBondOrders().length; ++i) {
            Integer indexTwo;
            int bondIndOne = full.getInterGroupBondIndices()[i * 2];
            int bondIndTwo = full.getInterGroupBondIndices()[i * 2 + 1];
            int bondOrder = full.getInterGroupBondOrders()[i];
            Integer indexOne = atomMap.get(bondIndOne);
            if (indexOne == null || (indexTwo = atomMap.get(bondIndTwo)) == null) continue;
            reduced.setInterGroupBond(indexOne, indexTwo, bondOrder);
        }
    }

    private static int getNumIntraGroupBonds(Set<Integer> indicesToAdd, StructureDataInterface structureDataInterface, int groupType, Integer[] centerAtomIndices) {
        if (indicesToAdd.size() == 1 && centerAtomIndices[groupType] != null) {
            return 0;
        }
        if (indicesToAdd.size() == 0) {
            return 0;
        }
        return structureDataInterface.getGroupBondOrders(groupType).length;
    }

    private static SummaryData getDataSummaryData(StructureDataInterface structureDataInterface, Integer[] centerAtomIndices) {
        SummaryData summaryData = new SummaryData();
        summaryData.numChains = 0;
        summaryData.numGroups = 0;
        summaryData.numAtoms = 0;
        summaryData.numBonds = 0;
        int groupCount = 0;
        int chainCount = 0;
        for (int i = 0; i < structureDataInterface.getNumModels(); ++i) {
            int numChains = structureDataInterface.getChainsPerModel()[i];
            int j = 0;
            while (j < numChains) {
                SummaryData summaryData2 = summaryData;
                Integer n = summaryData2.numChains;
                Integer n2 = summaryData2.numChains = Integer.valueOf(summaryData2.numChains + 1);
                String chainType = EncoderUtils.getTypeFromChainId(structureDataInterface, chainCount);
                int k = 0;
                while (k < structureDataInterface.getGroupsPerChain()[chainCount]) {
                    Integer n3;
                    Serializable serializable;
                    SummaryData summaryData3;
                    int groupType = structureDataInterface.getGroupTypeIndices()[groupCount];
                    Set<Integer> indicesToAdd = ReducedEncoder.getIndicesToAdd(structureDataInterface, groupType, chainType, centerAtomIndices);
                    if (indicesToAdd.size() > 0) {
                        summaryData3 = summaryData;
                        serializable = summaryData3.numGroups;
                        n3 = summaryData3.numGroups = Integer.valueOf(summaryData3.numGroups + 1);
                    }
                    for (int l = 0; l < structureDataInterface.getNumAtomsInGroup(groupType); ++l) {
                        if (!indicesToAdd.contains(l)) continue;
                        serializable = summaryData;
                        n3 = ((SummaryData)serializable).numAtoms;
                        Integer n4 = ((SummaryData)serializable).numAtoms = Integer.valueOf(((SummaryData)serializable).numAtoms + 1);
                    }
                    summaryData3 = summaryData;
                    Integer.valueOf(summaryData3.numBonds + ReducedEncoder.getNumIntraGroupBonds(indicesToAdd, structureDataInterface, groupType, centerAtomIndices));
                    summaryData3.numBonds = summaryData3.numBonds;
                    ++k;
                    ++groupCount;
                }
                ++j;
                ++chainCount;
            }
        }
        return summaryData;
    }

    private static Set<Integer> getIndicesToAdd(StructureDataInterface structure, int groupIndex, String chainType, Integer[] centerAtomIndices) {
        Set<Integer> atomIndices;
        block5: {
            block4: {
                atomIndices = Collections.emptySet();
                Integer atomIndex = centerAtomIndices[groupIndex];
                if (!chainType.equals("polymer")) break block4;
                if (atomIndex != null) {
                    atomIndices = Collections.singleton(atomIndex);
                } else {
                    atomIndices = new HashSet(structure.getNumAtomsInGroup(groupIndex));
                    for (int i = 0; i < structure.getNumAtomsInGroup(groupIndex); ++i) {
                        atomIndices.add(i);
                    }
                }
                break block5;
            }
            if (structure.getGroupName(groupIndex).equals("HOH") || structure.getGroupName(groupIndex).equals("DOD")) break block5;
            atomIndices = new HashSet(structure.getNumAtomsInGroup(groupIndex));
            for (int i = 0; i < structure.getNumAtomsInGroup(groupIndex); ++i) {
                atomIndices.add(i);
            }
        }
        return atomIndices;
    }

    private static Integer indexOfcAlpha(StructureDataInterface structureDataInterface, int groupIndex) {
        for (int i = 0; i < structureDataInterface.getNumAtomsInGroup(groupIndex); ++i) {
            String atomName = structureDataInterface.getGroupAtomNames(groupIndex)[i];
            String elementName = structureDataInterface.getGroupElementNames(groupIndex)[i];
            if (!atomName.equals(CALPHA_NAME) || !elementName.equals(CARBON_ELEMENT)) continue;
            return i;
        }
        return null;
    }

    private static Integer indexOfpAtom(StructureDataInterface structureDataInterface, int groupIndex) {
        for (int i = 0; i < structureDataInterface.getNumAtomsInGroup(groupIndex); ++i) {
            String atomName = structureDataInterface.getGroupAtomNames(groupIndex)[i];
            String elementName = structureDataInterface.getGroupElementNames(groupIndex)[i];
            if (!atomName.equals("P") || !elementName.equals("P")) continue;
            return i;
        }
        return null;
    }

    private static Integer[] getCenterAtomGroupIndices(StructureDataInterface structure) {
        int maxIndex = 0;
        for (int i = 0; i < structure.getGroupTypeIndices().length; ++i) {
            maxIndex = Math.max(maxIndex, structure.getGroupTypeIndices()[i]);
        }
        Integer[] centerAtomIndex = new Integer[maxIndex + 1];
        for (int i = 0; i < maxIndex + 1; ++i) {
            Integer index = ReducedEncoder.indexOfcAlpha(structure, i);
            if (index == null) {
                index = ReducedEncoder.indexOfpAtom(structure, i);
            }
            centerAtomIndex[i] = index;
        }
        return centerAtomIndex;
    }
}

