/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.decoder;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import org.rcsb.mmtf.dataholders.MmtfStructure;
import org.rcsb.mmtf.serialization.MessagePackSerialization;
import org.rcsb.mmtf.utils.CodecUtils;

public class ReaderUtils {
    private static final int BYTE_BUFFER_CHUNK_SIZE = 4096;

    public static MmtfStructure getDataFromUrl(String pdbId) throws IOException {
        return ReaderUtils.getDataFromUrl(pdbId, true, false);
    }

    public static MmtfStructure getDataFromUrl(String pdbId, boolean https, boolean reduced) throws IOException {
        byte[] bytes = ReaderUtils.getByteArrayFromUrl(pdbId, https, reduced);
        MessagePackSerialization mmtfBeanSeDeMessagePackImpl = new MessagePackSerialization();
        return mmtfBeanSeDeMessagePackImpl.deserialize((InputStream)new ByteArrayInputStream(ReaderUtils.deflateGzip(bytes)));
    }

    public static byte[] getByteArrayFromUrl(String pdbId) throws IOException {
        return ReaderUtils.getByteArrayFromUrl(pdbId, true, false);
    }

    public static byte[] getByteArrayFromUrl(String pdbId, boolean https, boolean reduced) throws IOException {
        URL url = new URL(CodecUtils.getMmtfEntryUrl((String)pdbId, (boolean)https, (boolean)reduced));
        try (InputStream inputStream = url.openStream();){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int n;
                byte[] byteChunk = new byte[4096];
                while ((n = inputStream.read(byteChunk)) > 0) {
                    baos.write(byteChunk, 0, n);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static byte[] deflateGzip(byte[] inputBytes) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(inputBytes));){
            int size;
            byte[] buffer = new byte[4096];
            while (gzipInputStream.available() == 1 && (size = gzipInputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, size);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static MmtfStructure getDataFromFile(Path filePath) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(ReaderUtils.readFile(filePath));){
            MmtfStructure mmtfStructure = ReaderUtils.getDataFromInputStream(is);
            return mmtfStructure;
        }
    }

    private static byte[] readFile(Path path) throws IOException {
        byte[] data = Files.readAllBytes(path);
        return data;
    }

    public static MmtfStructure getDataFromInputStream(InputStream inStream) throws IOException {
        if (!(inStream instanceof BufferedInputStream)) {
            inStream = new BufferedInputStream(inStream, 65536);
        }
        MessagePackSerialization mmtfBeanSeDeMessagePackImpl = new MessagePackSerialization();
        return mmtfBeanSeDeMessagePackImpl.deserialize(inStream);
    }
}

