/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.codec;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.rcsb.mmtf.utils.CodecUtils;

public class ArrayConverters {
    public static String[] decodeChainList(byte[] currentChainList, int length) {
        int outputLength = currentChainList.length / length;
        String[] outArray = new String[outputLength];
        for (int i = 0; i < outputLength; ++i) {
            outArray[i] = ArrayConverters.getChainId(currentChainList, i);
        }
        return outArray;
    }

    public static float[] convertIntsToFloats(int[] intArray, float floatDivider) {
        float[] outArray = new float[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            outArray[i] = (float)intArray[i] / floatDivider;
        }
        return outArray;
    }

    public static int[] convertByteToIntegers(byte[] byteArray) {
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        int outLength = byteArray.length;
        int[] outArray = new int[outLength];
        for (int i = 0; i < outLength; ++i) {
            outArray[i] = bb.get();
        }
        return outArray;
    }

    public static int[] convertTwoByteToIntegers(byte[] byteArray) {
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        int outLength = byteArray.length / 2;
        int[] outArray = new int[outLength];
        for (int i = 0; i < outLength; ++i) {
            outArray[i] = bb.getShort();
        }
        return outArray;
    }

    public static short[] convertTwoBytesToShorts(byte[] byteArray) {
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        int outLength = byteArray.length / 2;
        short[] outArray = new short[outLength];
        for (int i = 0; i < outLength; ++i) {
            outArray[i] = bb.getShort();
        }
        return outArray;
    }

    public static int[] convertFourByteToIntegers(byte[] byteArray) {
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        int outLength = byteArray.length / 4;
        int[] outArray = new int[outLength];
        for (int i = 0; i < outLength; ++i) {
            outArray[i] = bb.getInt();
        }
        return outArray;
    }

    public static int[] combineIntegers(int[] twoByteIntArray, int[] fourByteIntArray) {
        int[] outArray = new int[twoByteIntArray.length + fourByteIntArray.length / 2];
        int outIndex = 0;
        int twoByteIndex = 0;
        for (int fourByteIndex = 0; fourByteIndex < fourByteIntArray.length; fourByteIndex += 2) {
            outArray[outIndex] = fourByteIntArray[fourByteIndex];
            ++outIndex;
            for (int i = 0; i < fourByteIntArray[fourByteIndex + 1]; ++i) {
                outArray[outIndex] = twoByteIntArray[twoByteIndex];
                ++outIndex;
                ++twoByteIndex;
            }
        }
        return outArray;
    }

    public static char[] convertIntegerToChar(int[] integerArray) {
        char[] outArray = new char[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            outArray[i] = (char)integerArray[i];
        }
        return outArray;
    }

    private static String getChainId(byte[] byteArr, int chainIndex) {
        byte chainIdFour;
        byte chainIdThree;
        int incrementor = 0;
        StringBuilder sb = new StringBuilder();
        byte chainIdOne = byteArr[chainIndex * 4 + incrementor];
        sb.append((char)chainIdOne);
        byte chainIdTwo = byteArr[chainIndex * 4 + ++incrementor];
        if (chainIdTwo != 0) {
            sb.append((char)chainIdTwo);
        }
        if ((chainIdThree = byteArr[chainIndex * 4 + ++incrementor]) != 0) {
            sb.append((char)chainIdThree);
        }
        if ((chainIdFour = byteArr[chainIndex * 4 + ++incrementor]) != 0) {
            sb.append((char)chainIdFour);
        }
        return sb.toString();
    }

    public static byte[] convertIntegersToBytes(int[] intArray) {
        ByteBuffer bb = ByteBuffer.allocate(intArray.length);
        for (int i = 0; i < intArray.length; ++i) {
            bb.put((byte)intArray[i]);
        }
        return bb.array();
    }

    public static byte[] convertIntegersToTwoBytes(int[] intArray) {
        ByteBuffer bb = ByteBuffer.allocate(intArray.length * 2);
        for (int i = 0; i < intArray.length; ++i) {
            bb.putShort((short)intArray[i]);
        }
        return bb.array();
    }

    public static byte[] convertShortsToTwoBytes(short[] shortArray) {
        ByteBuffer bb = ByteBuffer.allocate(shortArray.length * 2);
        for (int i = 0; i < shortArray.length; ++i) {
            bb.putShort(shortArray[i]);
        }
        return bb.array();
    }

    public static byte[] convertIntegersToFourByte(int[] intArray) {
        ByteBuffer bb = ByteBuffer.allocate(intArray.length * 4);
        for (int i = 0; i < intArray.length; ++i) {
            bb.putInt(intArray[i]);
        }
        return bb.array();
    }

    public static int[] convertFloatsToInts(float[] floatArray, float floatMultiplier) {
        int[] outArray = new int[floatArray.length];
        for (int i = 0; i < floatArray.length; ++i) {
            outArray[i] = Math.round(floatArray[i] * floatMultiplier);
        }
        return outArray;
    }

    public static List<int[]> splitIntegers(int[] inputArray) {
        ArrayList<Integer> fourByteInts = new ArrayList<Integer>();
        ArrayList<Integer> twoByteInts = new ArrayList<Integer>();
        fourByteInts.add(inputArray[0]);
        int counter = 0;
        for (int i = 1; i < inputArray.length; ++i) {
            if (inputArray[i] > Short.MAX_VALUE || inputArray[i] < Short.MIN_VALUE) {
                fourByteInts.add(counter);
                fourByteInts.add(inputArray[i]);
                counter = 0;
                continue;
            }
            twoByteInts.add(inputArray[i]);
            ++counter;
        }
        fourByteInts.add(counter);
        ArrayList<int[]> outputList = new ArrayList<int[]>();
        outputList.add(CodecUtils.convertToIntArray(fourByteInts));
        outputList.add(CodecUtils.convertToIntArray(twoByteInts));
        return outputList;
    }

    public static int[] convertCharToIntegers(char[] charArray) {
        int[] outArray = new int[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            outArray[i] = charArray[i];
        }
        return outArray;
    }

    public static byte[] encodeChainList(String[] chainNames, int length) {
        byte[] outArr = new byte[chainNames.length * length];
        for (int i = 0; i < chainNames.length; ++i) {
            ArrayConverters.setChainId(chainNames[i], outArr, i);
        }
        return outArr;
    }

    private static void setChainId(String chainId, byte[] byteArr, int chainIndex) {
        char[] outChar = new char[4];
        if (chainId == null) {
            return;
        }
        int chainIdLen = chainId.length();
        chainId.getChars(0, chainIdLen, outChar, 0);
        byteArr[chainIndex * 4 + 0] = (byte)outChar[0];
        byteArr[chainIndex * 4 + 1] = chainIdLen > 1 ? (byte)outChar[1] : (byte)0;
        byteArr[chainIndex * 4 + 2] = chainIdLen > 2 ? (byte)outChar[2] : (byte)0;
        byteArr[chainIndex * 4 + 3] = chainIdLen > 3 ? (byte)outChar[3] : (byte)0;
    }

    public static int[] recursiveIndexEncode(int[] in) {
        ArrayList<Integer> outArr = new ArrayList<Integer>();
        for (int i = 0; i < in.length; ++i) {
            int curr = in[i];
            if (curr >= 0) {
                while (curr >= Short.MAX_VALUE) {
                    outArr.add((Integer)Short.MAX_VALUE);
                    curr -= Short.MAX_VALUE;
                }
            } else {
                while (curr <= Short.MIN_VALUE) {
                    outArr.add((Integer)Short.MIN_VALUE);
                    curr += Math.abs(Short.MIN_VALUE);
                }
            }
            outArr.add(curr);
        }
        return ArrayUtils.toPrimitive((Integer[])outArr.toArray(new Integer[outArr.size()]));
    }

    public static int[] recursiveIndexDecode(int[] in) {
        int[] original = new int[in.length];
        int encodedInd = 0;
        int decodedInd = 0;
        while (encodedInd < in.length) {
            int decodedVal = 0;
            while (in[encodedInd] == Short.MAX_VALUE || in[encodedInd] == Short.MIN_VALUE) {
                decodedVal += in[encodedInd];
                if (in[++encodedInd] != 0) continue;
            }
            original[decodedInd] = decodedVal += in[++encodedInd];
            ++decodedInd;
        }
        int[] out = new int[decodedInd];
        System.arraycopy(original, 0, out, 0, decodedInd);
        return out;
    }
}

