/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.rarefiedredis.redis.IRedisCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RedisListCache
implements IRedisCache<String, List<String>> {
    private Map<String, List<String>> cache = new HashMap<String, List<String>>();

    @Override
    public Boolean exists(String key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void remove(String key) {
        this.cache.remove(key);
    }

    @Override
    public void set(String key, String value, Object ... arguments) {
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, new LinkedList());
        }
        if (arguments.length == 1) {
            this.cache.get(key).add((Integer)arguments[0], value);
        } else {
            this.cache.get(key).add(value);
        }
    }

    @Override
    public List<String> get(String key) {
        return this.cache.get(key);
    }

    @Override
    public Boolean removeValue(String key, String value) {
        if (!this.exists(key).booleanValue()) {
            return false;
        }
        return this.cache.get(key).remove(value);
    }

    @Override
    public String type() {
        return "list";
    }
}

