/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.oauth;

import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.gui.GUI;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.Req;
import org.rapidoid.http.ReqHandler;
import org.rapidoid.log.Log;
import org.rapidoid.oauth.DefaultOAuthStateCheck;
import org.rapidoid.oauth.OAuthLoginHandler;
import org.rapidoid.oauth.OAuthProvider;
import org.rapidoid.oauth.OAuthStateCheck;
import org.rapidoid.oauth.OAuthTokenHandler;
import org.rapidoid.render.Template;
import org.rapidoid.render.Templates;
import org.rapidoid.setup.Setup;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.value.Value;

public class OAuth
extends RapidoidThing {
    private static final Template LOGIN_BTN = Templates.load((String)"oauth-login-button.html");
    private static OAuthStateCheck STATE_CHECK;
    private static final Config OAUTH;
    private static final Value<String> DOMAIN;

    public static void bootstrap(Setup setup) {
        OAuth.register(setup, new DefaultOAuthStateCheck(), new OAuthProvider[0]);
    }

    public static void register(Setup setup, OAuthProvider ... providers) {
        OAuth.register(setup, new DefaultOAuthStateCheck(), providers);
    }

    public static void register(Setup setup, OAuthStateCheck stateCheck, OAuthProvider ... providers) {
        if (OAUTH.isEmpty()) {
            Log.warn((String)"OAuth is not configured!");
        }
        STATE_CHECK = stateCheck;
        if (providers == null || providers.length == 0) {
            providers = OAuthProvider.PROVIDERS;
        }
        StringBuilder loginHtml = new StringBuilder();
        loginHtml.append("<div class=\"container-fluid text-center\">");
        for (OAuthProvider provider : providers) {
            String name = provider.getName().toLowerCase();
            String loginUri = Msc.specialUri((String[])new String[]{name + "Login"});
            String callbackUri = Msc.specialUri((String[])new String[]{name + "OauthCallback"});
            Config providerConfig = OAUTH.sub(new String[]{name});
            Value clientId = providerConfig.entry("clientId").str();
            Value clientSecret = providerConfig.entry("clientSecret").str();
            setup.get(loginUri).html((ReqHandler)new OAuthLoginHandler(provider, DOMAIN));
            setup.get(callbackUri).html((ReqHandler)new OAuthTokenHandler(provider, setup.custom(), DOMAIN, stateCheck, (Value<String>)clientId, (Value<String>)clientSecret, callbackUri));
            loginHtml.append(LOGIN_BTN.render((Object)U.map((Object)"uri", (Object)loginUri, (Object)"provider", (Object)provider.getName())));
        }
        loginHtml.append("</div>");
        final String loginPage = loginHtml.toString();
        setup.get(Msc.specialUri((String[])new String[]{"oauth"})).mvc(new ReqHandler(){

            public Object execute(Req x) throws Exception {
                return GUI.hardcoded((String)loginPage);
            }
        });
    }

    public static String getLoginURL(Req req, OAuthProvider provider, String oauthDomain) {
        if (OAUTH.isEmpty()) {
            Log.warn((String)"OAuth is not configured!");
        }
        String name = provider.getName().toLowerCase();
        Config providerConfig = OAUTH.sub(new String[]{name});
        Value clientId = providerConfig.entry("clientId").str();
        Value clientSecret = providerConfig.entry("clientSecret").str();
        String callbackPath = Msc.specialUri((String[])new String[]{name + "OauthCallback"});
        boolean popup = req.param("popup", null) != null;
        String redirectUrl = U.notEmpty((String)oauthDomain) ? oauthDomain + callbackPath : HttpUtils.constructUrl((Req)req, (String)callbackPath);
        String statePrefix = popup ? "P" : "N";
        String state = statePrefix + STATE_CHECK.generateState((Value<String>)clientSecret, req.sessionId());
        try {
            OAuthClientRequest request = OAuthClientRequest.authorizationLocation((String)provider.getAuthEndpoint()).setClientId((String)clientId.str().get()).setRedirectURI(redirectUrl).setScope(provider.getEmailScope()).setState(state).setResponseType("code").buildQueryMessage();
            return request.getLocationUri();
        }
        catch (OAuthSystemException e) {
            throw U.rte((Throwable)e);
        }
    }

    static {
        OAUTH = Conf.OAUTH;
        DOMAIN = Conf.APP.entry("domain").str();
    }
}

