/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.setup;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.AnyObj;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.PersisterProvider;
import org.rapidoid.data.JSON;
import org.rapidoid.env.Env;
import org.rapidoid.env.RapidoidEnv;
import org.rapidoid.http.FastHttp;
import org.rapidoid.http.HttpRoutes;
import org.rapidoid.http.ReqHandler;
import org.rapidoid.http.ReqRespHandler;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.customize.ViewResolver;
import org.rapidoid.http.handler.HttpHandler;
import org.rapidoid.http.handler.optimized.DelegatingParamsAwareReqHandler;
import org.rapidoid.http.handler.optimized.DelegatingParamsAwareReqRespHandler;
import org.rapidoid.http.impl.AbstractViewResolver;
import org.rapidoid.http.impl.HttpRoutesImpl;
import org.rapidoid.http.impl.RouteOptions;
import org.rapidoid.http.processor.HttpProcessor;
import org.rapidoid.ioc.Beans;
import org.rapidoid.ioc.IoC;
import org.rapidoid.ioc.IoCContext;
import org.rapidoid.job.Jobs;
import org.rapidoid.lambda.NParamLambda;
import org.rapidoid.lambda.OneParamLambda;
import org.rapidoid.lambda.TwoParamLambda;
import org.rapidoid.log.Log;
import org.rapidoid.net.Server;
import org.rapidoid.setup.App;
import org.rapidoid.setup.AppRestartProcessor;
import org.rapidoid.setup.AppStatus;
import org.rapidoid.setup.CustomizableSetupAwarePersisterProvider;
import org.rapidoid.setup.DefaultSetup;
import org.rapidoid.setup.My;
import org.rapidoid.setup.On;
import org.rapidoid.setup.OnError;
import org.rapidoid.setup.OnRoute;
import org.rapidoid.setup.PojoHandlersSetup;
import org.rapidoid.u.U;
import org.rapidoid.util.AppInfo;
import org.rapidoid.util.LazyInit;
import org.rapidoid.util.Msc;
import org.rapidoid.util.MscOpts;
import org.rapidoid.util.Once;

public class Setup
extends RapidoidInitializer {
    static final Config MAIN_CFG = Msc.isPlatform() ? Conf.RAPIDOID : Conf.ON;
    static final Config ADMIN_CFG = Msc.isPlatform() ? Conf.RAPIDOID_ADMIN : Conf.ADMIN;
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private static final int DEFAULT_PORT = Msc.isPlatform() ? 8888 : 8080;
    private static final LazyInit<DefaultSetup> DEFAULT = new LazyInit((Callable)new Callable<DefaultSetup>(){

        @Override
        public DefaultSetup call() throws Exception {
            return new DefaultSetup();
        }
    });
    static final List<Setup> instances = Coll.synchronizedList((Object[])new Setup[0]);
    private final String name;
    private final String zone;
    private final Config serverConfig;
    private final IoCContext ioCContext;
    private final Customization customization;
    private final HttpRoutesImpl routes;
    private volatile RouteOptions defaults = new RouteOptions();
    private volatile Integer port;
    private volatile String address;
    private volatile HttpProcessor processor;
    private volatile boolean listening;
    private volatile Server server;
    private volatile boolean activated;
    private volatile boolean reloaded;
    private volatile boolean autoActivating = !Setup.isAppSetupAtomic();
    private volatile Runnable onInit;
    private final Once bootstrappedBeans = new Once();
    private final LazyInit<FastHttp> lazyHttp = new LazyInit((Callable)new Callable<FastHttp>(){

        @Override
        public FastHttp call() throws Exception {
            return Setup.this.initHttp();
        }
    });

    public static Setup create(String name) {
        IoCContext ioc = IoC.createContext().name(name);
        Config config = Conf.section((String)name);
        Customization customization = new Customization(name, My.custom(), config);
        HttpRoutesImpl routes = new HttpRoutesImpl(name, customization);
        Setup setup = new Setup(name, "main", ioc, config, customization, routes);
        instances.add(setup);
        return setup;
    }

    public void destroy() {
        this.halt();
        instances.remove((Object)this);
    }

    Setup(String name, String zone, IoCContext ioCContext, Config serverConfig, Customization customization, HttpRoutesImpl routes) {
        this.name = name;
        this.zone = zone;
        this.ioCContext = ioCContext;
        this.serverConfig = serverConfig;
        this.customization = customization;
        this.routes = routes;
        this.defaults.zone(zone);
    }

    static Setup on() {
        return ((DefaultSetup)((Object)Setup.DEFAULT.get())).on;
    }

    static Setup admin() {
        return ((DefaultSetup)((Object)Setup.DEFAULT.get())).admin;
    }

    private FastHttp initHttp() {
        if (this.isAdminAndSameAsApp() && Setup.on().lazyHttp.isInitialized()) {
            return Setup.on().http();
        }
        if (this.isAppAndSameAsAdmin() && Setup.admin().lazyHttp.isInitialized()) {
            return Setup.admin().http();
        }
        if (this.isAppOrAdminOnSameServer()) {
            U.must((Setup.on().routes == Setup.admin().routes ? 1 : 0) != 0);
            return new FastHttp(Setup.on().routes, Setup.on().serverConfig);
        }
        return new FastHttp(this.routes, this.serverConfig);
    }

    public FastHttp http() {
        return (FastHttp)this.lazyHttp.get();
    }

    private synchronized void listen() {
        if (!this.listening && !this.reloaded) {
            Object proc;
            App.inferCallers();
            this.listening = true;
            Object object = proc = this.processor != null ? this.processor : this.http();
            if (Env.dev() && !On.changes().isIgnored() && MscOpts.hasRapidoidWatch()) {
                proc = new AppRestartProcessor(this, (HttpProcessor)proc);
                On.changes().byDefaultRestart();
            }
            if (this.delegateAdminToApp()) {
                this.server = Setup.on().server();
            } else if (this.delegateAppToAdmin()) {
                this.server = Setup.admin().server();
            }
            if (this.server == null) {
                int targetPort;
                if (this.isAppOrAdminOnSameServer()) {
                    targetPort = Setup.on().port();
                    this.server = proc.listen(Setup.on().address(), targetPort);
                } else {
                    targetPort = this.port();
                    this.server = proc.listen(this.address(), targetPort);
                }
                Log.info((String)"!Server has started", (String)"setup", (Object)this.name(), (String)"!home", (Object)("http://localhost:" + targetPort));
                Log.info((String)"!Static resources will be served from the following locations", (String)"setup", (Object)this.name(), (String)"!locations", (Object)this.custom().staticFilesPath());
            }
        }
    }

    private boolean isAppOrAdminOnSameServer() {
        return Setup.appAndAdminOnSameServer() && (this.isApp() || this.isAdmin());
    }

    private boolean delegateAdminToApp() {
        return this.isAdminAndSameAsApp() && Setup.on().server != null;
    }

    private boolean delegateAppToAdmin() {
        return this.isAppAndSameAsAdmin() && Setup.admin().server != null;
    }

    static boolean appAndAdminOnSameServer() {
        String mainPort = (String)MAIN_CFG.entry("port").str().getOrNull();
        String adminPort = (String)ADMIN_CFG.entry("port").str().getOrNull();
        return U.eq((Object)mainPort, (Object)adminPort);
    }

    private boolean isAppAndSameAsAdmin() {
        return this.isApp() && Setup.appAndAdminOnSameServer();
    }

    private boolean isAdminAndSameAsApp() {
        return this.isAdmin() && Setup.appAndAdminOnSameServer();
    }

    public boolean isAdmin() {
        return this == Setup.admin();
    }

    public boolean isApp() {
        return this == Setup.on();
    }

    void autoActivate() {
        if (this.autoActivating) {
            this.activate();
        }
    }

    public synchronized void activate() {
        RapidoidEnv.touch();
        if (this.activated) {
            return;
        }
        this.activated = true;
        Runnable initializer = this.onInit;
        if (initializer != null) {
            initializer.run();
        }
        if (!this.reloaded) {
            this.listen();
        }
        if (this.isApp()) {
            AppInfo.isAppServerActive = true;
            AppInfo.appPort = this.port();
        }
        if (this.isAdmin()) {
            AppInfo.isAdminServerActive = true;
            AppInfo.adminPort = this.port();
        }
    }

    public OnRoute route(String verb, String path) {
        return new OnRoute(this, verb.toUpperCase(), path);
    }

    public OnRoute any(String path) {
        return new OnRoute(this, "ANY", path);
    }

    public OnRoute get(String path) {
        return new OnRoute(this, "GET", path);
    }

    public OnRoute post(String path) {
        return new OnRoute(this, "POST", path);
    }

    public OnRoute put(String path) {
        return new OnRoute(this, "PUT", path);
    }

    public OnRoute delete(String path) {
        return new OnRoute(this, "DELETE", path);
    }

    public OnRoute patch(String path) {
        return new OnRoute(this, "PATCH", path);
    }

    public OnRoute options(String path) {
        return new OnRoute(this, "OPTIONS", path);
    }

    public OnRoute head(String path) {
        return new OnRoute(this, "HEAD", path);
    }

    public OnRoute trace(String path) {
        return new OnRoute(this, "TRACE", path);
    }

    public OnRoute page(String path) {
        return new OnRoute(this, "GET,POST", path);
    }

    public Setup req(ReqHandler handler) {
        this.routes.addGenericHandler((HttpHandler)new DelegatingParamsAwareReqHandler(this.http(), (HttpRoutes)this.routes, this.opts(), (OneParamLambda<?, ?>)handler));
        this.autoActivate();
        return this;
    }

    public Setup req(ReqRespHandler handler) {
        this.routes.addGenericHandler((HttpHandler)new DelegatingParamsAwareReqRespHandler(this.http(), (HttpRoutes)this.routes, this.opts(), (TwoParamLambda<?, ?, ?>)handler));
        this.autoActivate();
        return this;
    }

    public Setup req(HttpHandler handler) {
        this.routes.addGenericHandler(handler);
        this.autoActivate();
        return this;
    }

    public Setup beans(Object ... beans) {
        RapidoidEnv.touch();
        for (Object bean : beans = AnyObj.flat((Object[])beans)) {
            U.notNull((Object)bean, (String)"bean", (Object[])new Object[0]);
            if (!(bean instanceof NParamLambda)) continue;
            throw U.rte((String)("Expected a bean, but found lambda: " + bean));
        }
        App.filterAndInvokeMainClasses(beans);
        PojoHandlersSetup.from(this, beans).register();
        return this;
    }

    public Setup port(int port) {
        this.port = port;
        return this;
    }

    public Setup address(String address) {
        this.address = address;
        return this;
    }

    public Setup processor(HttpProcessor processor) {
        U.must((!this.listening ? 1 : 0) != 0, (String)"The server was already initialized!");
        this.processor = processor;
        return this;
    }

    public synchronized Setup shutdown() {
        if (this.server != null) {
            if (this.server.isActive()) {
                this.server.shutdown();
            }
            this.server = null;
        }
        this.reset();
        return this;
    }

    public synchronized Setup halt() {
        if (this.server != null) {
            if (this.server.isActive()) {
                this.server.halt();
            }
            this.server = null;
        }
        this.reset();
        return this;
    }

    public void reset() {
        this.http().resetConfig();
        this.listening = false;
        this.reloaded = false;
        this.port = null;
        this.lazyHttp.reset();
        this.address = null;
        this.processor = null;
        this.activated = false;
        this.ioCContext.reset();
        this.server = null;
        this.autoActivating = !Setup.isAppSetupAtomic();
        this.defaults = new RouteOptions();
        this.defaults().zone(this.zone);
        if (this.isApp()) {
            AppInfo.isAppServerActive = false;
            AppInfo.appPort = 0;
        }
        if (this.isAdmin()) {
            AppInfo.isAdminServerActive = false;
            AppInfo.adminPort = 0;
        }
        this.bootstrappedBeans.reset();
        Setup.initDefaults();
    }

    public Server server() {
        return this.server;
    }

    public Map<String, Object> attributes() {
        return this.http().attributes();
    }

    public Setup scan(String ... packages) {
        if (!this.bootstrappedBeans.go()) {
            return this;
        }
        this.beans(App.findBeans(packages).toArray());
        return this;
    }

    public Setup deregister(String verb, String path) {
        this.routes.remove(verb, path);
        return this;
    }

    public Setup deregister(Object ... controllers) {
        PojoHandlersSetup.from(this, controllers).deregister();
        return this;
    }

    public IoCContext context() {
        return this.ioCContext;
    }

    public void reload() {
        this.reloaded = true;
        this.bootstrappedBeans.reset();
        this.ioCContext.reset();
        this.http().resetConfig();
        this.defaults = new RouteOptions();
        this.defaults.zone(this.zone);
        this.attributes().clear();
        ViewResolver viewResolver = this.custom().viewResolver();
        if (viewResolver instanceof AbstractViewResolver) {
            ((AbstractViewResolver)viewResolver).reset();
        }
    }

    static List<Setup> instances() {
        return Collections.unmodifiableList(instances);
    }

    public Config config() {
        return this.serverConfig;
    }

    public Customization custom() {
        return this.customization;
    }

    public HttpRoutes routes() {
        return this.routes;
    }

    private RouteOptions opts() {
        return new RouteOptions();
    }

    public String name() {
        return this.name;
    }

    public RouteOptions defaults() {
        return this.defaults;
    }

    public String zone() {
        return this.zone;
    }

    public boolean isRunning() {
        return this.activated;
    }

    public static synchronized void haltAll() {
        for (Setup setup : Setup.instances()) {
            setup.halt();
        }
    }

    public static synchronized void shutdownAll() {
        for (Setup setup : Setup.instances()) {
            setup.shutdown();
        }
    }

    public static synchronized boolean isAnyRunning() {
        for (Setup setup : Setup.instances()) {
            if (!setup.isRunning()) continue;
            return true;
        }
        return false;
    }

    public int port() {
        if (this.port == null) {
            this.port = (Integer)this.serverConfig.entry("port").or((Object)DEFAULT_PORT);
        }
        U.must((this.port >= 0 ? 1 : 0) != 0, (String)"The port of server setup '%s' is negative!", (Object)this.name());
        return this.port;
    }

    public String address() {
        if (this.address == null) {
            this.address = (String)this.serverConfig.entry("address").or((Object)DEFAULT_ADDRESS);
        }
        U.must((boolean)U.notEmpty((String)this.address), (String)"The address of server setup '%s' is empty!", (Object)this.name());
        return this.address;
    }

    public OnError error(Class<? extends Throwable> error) {
        return new OnError(this.customization, error);
    }

    public void register(Beans beans) {
        this.beans(beans.getAnnotated((Collection)U.set((Object[])IoC.ANNOTATIONS)));
    }

    static void initDefaults() {
        DefaultSetup defaultSetup = (DefaultSetup)((Object)DEFAULT.getValue());
        if (defaultSetup != null) {
            defaultSetup.initDefaults();
        }
    }

    public String toString() {
        return "Setup{name='" + this.name + '\'' + ", zone='" + this.zone + '\'' + ", serverConfig=" + this.serverConfig + ", customization=" + this.customization + ", routes=" + this.routes + '}';
    }

    public void onInit(Runnable onInit) {
        this.onInit = onInit;
    }

    public boolean autoActivating() {
        return this.autoActivating;
    }

    public Setup autoActivating(boolean autoActivating) {
        this.autoActivating = autoActivating;
        return this;
    }

    public static void ready() {
        for (Setup setup : instances) {
            setup.activate();
        }
    }

    private static boolean isAppSetupAtomic() {
        return App.status() == AppStatus.INITIALIZING;
    }

    static {
        if (Ctxs.getPersisterProvider() == null) {
            Ctxs.setPersisterProvider((PersisterProvider)new CustomizableSetupAwarePersisterProvider());
        }
        JSON.warmUp();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Setup.shutdownAll();
                Jobs.shutdownNow();
            }
        });
    }
}

