/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.setup;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.annotation.Controller;
import org.rapidoid.annotation.DELETE;
import org.rapidoid.annotation.GET;
import org.rapidoid.annotation.HEAD;
import org.rapidoid.annotation.OPTIONS;
import org.rapidoid.annotation.PATCH;
import org.rapidoid.annotation.POST;
import org.rapidoid.annotation.PUT;
import org.rapidoid.annotation.Page;
import org.rapidoid.annotation.TRACE;
import org.rapidoid.annotation.Transaction;
import org.rapidoid.beany.Metadata;
import org.rapidoid.cache.Cached;
import org.rapidoid.cls.Cls;
import org.rapidoid.ioc.IoCContext;
import org.rapidoid.log.Log;
import org.rapidoid.security.Secure;
import org.rapidoid.setup.OnRoute;
import org.rapidoid.setup.Setup;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class PojoHandlersSetup
extends RapidoidThing {
    private static final Set<String> CONTROLLER_ANNOTATIONS = U.set((Object[])new String[]{Page.class.getName(), GET.class.getName(), POST.class.getName(), PUT.class.getName(), DELETE.class.getName(), PATCH.class.getName(), OPTIONS.class.getName(), HEAD.class.getName(), TRACE.class.getName()});
    private final Setup setup;
    private final Object[] beans;

    private PojoHandlersSetup(Setup setup, Object[] beans) {
        this.setup = setup;
        this.beans = beans;
    }

    public static PojoHandlersSetup from(Setup setup, Object[] beans) {
        return new PojoHandlersSetup(setup, beans);
    }

    public void register() {
        this.process(true);
    }

    public void deregister() {
        this.process(false);
    }

    private void process(boolean register) {
        for (Object bean : this.beans) {
            this.processBean(register, bean);
        }
    }

    private void processBean(boolean register, Object bean) {
        Class<?> clazz;
        U.notNull((Object)bean, (String)"bean", (Object[])new Object[0]);
        IoCContext context = this.setup.context();
        if (bean instanceof Class) {
            clazz = (Class<?>)bean;
            bean = null;
        } else {
            clazz = bean.getClass();
        }
        if (!Cls.isAppBeanType(clazz)) {
            throw new RuntimeException("Expected a bean, but found value of type: " + clazz.getName());
        }
        if (!Msc.matchingProfile(clazz)) {
            return;
        }
        Log.debug((String)"Processing bean", (String)"class", clazz, (String)"instance", (Object)bean);
        List<String> componentPaths = this.getControllerUris(clazz);
        for (String ctxPath : componentPaths) {
            for (Method method : Cls.getMethods(clazz)) {
                if (!this.shouldExpose(method)) continue;
                if (bean == null) {
                    bean = register ? context.singleton(clazz) : null;
                }
                this.registerOrDeregister(register, bean, ctxPath, method);
            }
        }
    }

    private boolean shouldExpose(Method method) {
        boolean isUserDefined = !method.getDeclaringClass().equals(Object.class);
        int modifiers = method.getModifiers();
        boolean isAbstract = Modifier.isAbstract(modifiers);
        boolean isStatic = Modifier.isStatic(modifiers);
        boolean isPrivate = Modifier.isPrivate(modifiers);
        boolean isProtected = Modifier.isProtected(modifiers);
        if (!(!isUserDefined || isAbstract || isStatic || isPrivate || isProtected || method.getAnnotations().length <= 0)) {
            for (Annotation ann : method.getAnnotations()) {
                String annoName = ann.annotationType().getName();
                if (!CONTROLLER_ANNOTATIONS.contains(annoName)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<String> getControllerUris(Class<?> component) {
        Controller controller = (Controller)Metadata.classAnnotation(component, Controller.class);
        if (controller != null) {
            return U.list((Object[])new String[]{controller.value()});
        }
        return U.list((Object[])new String[]{"/"});
    }

    private void registerOrDeregister(boolean register, Object bean, String ctxPath, Method method) {
        for (Annotation ann : method.getAnnotations()) {
            String path;
            if (ann instanceof Page) {
                Page page = (Page)ann;
                String verb = page.verb().verb();
                String path2 = this.pathOf(method, ctxPath, this.uriOf(ann));
                if (register) {
                    OnRoute route = this.route(this.setup.route(verb, path2), method);
                    if (U.notEmpty((String)page.view())) {
                        route.view(page.view());
                    }
                    if (page.raw()) {
                        route.html(method, bean);
                        continue;
                    }
                    route.mvc(method, bean);
                    continue;
                }
                this.setup.deregister(verb, path2);
                continue;
            }
            if (ann instanceof GET) {
                path = this.pathOf(method, ctxPath, this.uriOf(ann));
                if (register) {
                    this.route(this.setup.get(path), method).json(method, bean);
                    continue;
                }
                this.setup.deregister("GET", path);
                continue;
            }
            if (ann instanceof POST) {
                path = this.pathOf(method, ctxPath, this.uriOf(ann));
                if (register) {
                    this.route(this.setup.post(path), method).json(method, bean);
                    continue;
                }
                this.setup.deregister("POST", path);
                continue;
            }
            if (ann instanceof PUT) {
                path = this.pathOf(method, ctxPath, this.uriOf(ann));
                if (register) {
                    this.route(this.setup.put(path), method).json(method, bean);
                    continue;
                }
                this.setup.deregister("PUT", path);
                continue;
            }
            if (ann instanceof DELETE) {
                path = this.pathOf(method, ctxPath, this.uriOf(ann));
                if (register) {
                    this.route(this.setup.delete(path), method).json(method, bean);
                    continue;
                }
                this.setup.deregister("DELETE", path);
                continue;
            }
            if (ann instanceof PATCH) {
                path = this.pathOf(method, ctxPath, this.uriOf(ann));
                if (register) {
                    this.route(this.setup.patch(path), method).json(method, bean);
                    continue;
                }
                this.setup.deregister("PATCH", path);
                continue;
            }
            if (ann instanceof OPTIONS) {
                path = this.pathOf(method, ctxPath, this.uriOf(ann));
                if (register) {
                    this.route(this.setup.options(path), method).json(method, bean);
                    continue;
                }
                this.setup.deregister("OPTIONS", path);
                continue;
            }
            if (ann instanceof HEAD) {
                path = this.pathOf(method, ctxPath, this.uriOf(ann));
                if (register) {
                    this.route(this.setup.head(path), method).json(method, bean);
                    continue;
                }
                this.setup.deregister("HEAD", path);
                continue;
            }
            if (!(ann instanceof TRACE)) continue;
            path = this.pathOf(method, ctxPath, this.uriOf(ann));
            if (register) {
                this.route(this.setup.trace(path), method).json(method, bean);
                continue;
            }
            this.setup.deregister("TRACE", path);
        }
    }

    private OnRoute route(OnRoute route, Method method) {
        Transaction transaction = method.getAnnotation(Transaction.class);
        if (transaction != null) {
            route.transaction(transaction.value());
        }
        Set rolesAllowed = Secure.getRolesAllowed((Method)method);
        String[] roles = (String[])U.arrayOf(String.class, (Iterable)rolesAllowed);
        route.roles(roles);
        Cached cached = method.getAnnotation(Cached.class);
        if (cached != null) {
            route.cacheTTL(cached.ttl());
        }
        return route;
    }

    private String uriOf(Annotation ann) {
        Method valueMethod = Cls.getMethod(ann.getClass(), (String)"value", (Class[])new Class[0]);
        String uri = (String)Cls.invoke((Method)valueMethod, (Object)ann, (Object[])new Object[0]);
        if (U.isEmpty((String)uri)) {
            Method uriMethod = Cls.getMethod(ann.getClass(), (String)"uri", (Class[])new Class[0]);
            uri = (String)Cls.invoke((Method)uriMethod, (Object)ann, (Object[])new Object[0]);
        }
        return uri;
    }

    private String pathOf(Method method, String ctxPath, String uri) {
        String path = !U.isEmpty((String)uri) ? uri : method.getName();
        return Msc.uri((String[])new String[]{ctxPath, path});
    }
}

