/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.reverseproxy;

import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.log.Log;
import org.rapidoid.reverseproxy.LoadBalancer;
import org.rapidoid.reverseproxy.ProxyMapping;
import org.rapidoid.reverseproxy.ProxyUpstream;
import org.rapidoid.reverseproxy.ReverseProxy;
import org.rapidoid.reverseproxy.RoundRobinLoadBalancer;
import org.rapidoid.setup.On;
import org.rapidoid.setup.OnRoute;
import org.rapidoid.setup.Setup;
import org.rapidoid.u.U;

public class ReverseProxyMapDSL
extends RapidoidThing {
    private final String uriPrefix;
    private volatile List<String> upstreams;
    private volatile String[] roles;
    private volatile Long cacheTTL;
    private volatile Integer cacheCapacity;
    private volatile LoadBalancer loadBalancer;

    public ReverseProxyMapDSL(String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }

    public ReverseProxyMapDSL to(String ... upstreams) {
        return this.to(U.list((Object[])upstreams));
    }

    public ReverseProxyMapDSL to(List<String> upstreams) {
        this.upstreams = ProxyUpstream.refine(upstreams);
        return this;
    }

    public ReverseProxy addTo(Setup setup) {
        Log.info((String)"!Reverse proxy mapping", (String)"!uriPrefix", (Object)this.uriPrefix, (String)"!upstreams", this.upstreams);
        ReverseProxy proxy = this.createReverseProxy();
        U.must((boolean)this.uriPrefix.startsWith("/"), (String)"The URI prefix must start with '/'");
        String path = this.uriPrefix.equals("/") ? "/*" : this.uriPrefix + "/*";
        OnRoute route = setup.any(path);
        if (this.roles != null) {
            route.roles(this.roles);
        }
        if (this.cacheTTL != null) {
            route.cacheTTL(this.cacheTTL);
        }
        if (this.cacheCapacity != null) {
            route.cacheCapacity(this.cacheCapacity);
        }
        route.serve(proxy);
        return proxy;
    }

    public ReverseProxy add() {
        return this.addTo(On.setup());
    }

    private ReverseProxy createReverseProxy() {
        List proxyUpstreams = U.list();
        U.notNull(this.upstreams, (String)"proxy upstreams", (Object[])new Object[0]);
        for (String upstream : this.upstreams) {
            proxyUpstreams.add(new ProxyUpstream(upstream));
        }
        LoadBalancer balancer = this.loadBalancer != null ? this.loadBalancer : new RoundRobinLoadBalancer();
        ProxyMapping mapping = new ProxyMapping(this.uriPrefix, balancer, proxyUpstreams);
        return new ReverseProxy(mapping);
    }

    public String[] roles() {
        return this.roles;
    }

    public ReverseProxyMapDSL roles(String ... roles) {
        this.roles = roles;
        return this;
    }

    public Long cacheTTL() {
        return this.cacheTTL;
    }

    public ReverseProxyMapDSL cacheTTL(long cacheTTL) {
        this.cacheTTL = cacheTTL;
        return this;
    }

    public Integer cacheCapacity() {
        return this.cacheCapacity;
    }

    public ReverseProxyMapDSL cacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
        return this;
    }

    public LoadBalancer loadBalancer() {
        return this.loadBalancer;
    }

    public ReverseProxyMapDSL loadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }
}

