/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.Resp;
import org.rapidoid.http.View;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.customize.PageDecorator;
import org.rapidoid.http.customize.ViewResolver;
import org.rapidoid.http.impl.ReqImpl;
import org.rapidoid.http.impl.RespImpl;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.MscOpts;
import org.rapidoid.writable.ReusableWritable;

public class ResponseRenderer
extends RapidoidThing {
    public static byte[] renderMvc(ReqImpl req, Resp resp) {
        ByteArrayOutputStream out;
        boolean mandatory;
        boolean rendered;
        Object result = resp.result();
        String content = null;
        if (ResponseRenderer.shouldRenderView(resp) && (rendered = ResponseRenderer.renderView(req, resp, result, mandatory = ((RespImpl)resp).hasCustomView(), out = new ByteArrayOutputStream()))) {
            content = new String(out.toByteArray());
        }
        if (content == null) {
            Object respResult = U.or((Object)result, (Object)"");
            content = new String(HttpUtils.responseToBytes(req, respResult, MediaType.HTML_UTF_8, null));
        }
        return ResponseRenderer.renderPage(req, content);
    }

    private static boolean shouldRenderView(Resp resp) {
        if (!resp.mvc()) {
            return false;
        }
        Object result = resp.result();
        if (result == null) {
            return true;
        }
        if (((RespImpl)resp).hasCustomView()) {
            return U.notEmpty((String)resp.view());
        }
        return true;
    }

    public static boolean renderView(ReqImpl req, Resp resp, Object result, boolean mandatory, ByteArrayOutputStream out) {
        View view;
        Map mvcModel;
        String viewName = resp.view();
        HttpUtils.validateViewName(viewName);
        Customization custom = Customization.of(req);
        ViewResolver viewResolver = custom.viewResolver();
        U.must((viewResolver != null ? 1 : 0) != 0, (String)"A view resolver wasn't configured!");
        if (result != null) {
            mvcModel = result;
            if (result instanceof Map) {
                Map map = U.map();
                map.putAll(req.params());
                map.putAll(result);
                map.putAll(resp.model());
                mvcModel = map;
            } else {
                U.must((boolean)resp.model().isEmpty(), (String)"The result must be a Map when custom model properties are assigned!");
            }
        } else {
            mvcModel = resp.model();
        }
        try {
            view = viewResolver.getView(viewName, custom.templateLoader());
        }
        catch (Throwable e) {
            throw U.rte((String)("Error while retrieving view: " + viewName), (Throwable)e);
        }
        if (view != null) {
            try {
                view.render(mvcModel, out);
            }
            catch (Throwable e) {
                throw U.rte((String)("Error while rendering view: " + viewName), (Throwable)e);
            }
        } else {
            U.must((!mandatory ? 1 : 0) != 0, (String)"The view '%s' doesn't exist!", (Object)viewName);
        }
        return view != null;
    }

    public static byte[] renderPage(ReqImpl req, String content) {
        PageDecorator pageDecorator = Customization.of(req).pageDecorator();
        U.must((pageDecorator != null ? 1 : 0) != 0, (String)"A page decorator wasn't configured!");
        ReusableWritable out = Msc.locals().pageRenderingStream();
        try {
            pageDecorator.renderPage(req, content, (OutputStream)out);
        }
        catch (Exception e) {
            throw U.rte((String)"Error while rendering page!", (Throwable)e);
        }
        return out.copy();
    }

    private static Object wrapGuiContent(Object content) {
        if (MscOpts.hasRapidoidGUI()) {
            Object[] items = null;
            if (content instanceof Collection) {
                items = U.array((Iterable)((Collection)content));
            } else if (content instanceof Object[]) {
                items = (Object[])content;
            }
            if (items != null) {
                return Cls.newInstance((Class)Cls.get((String)"org.rapidoid.html.ElementGroup"), (Object[])new Object[]{items});
            }
        }
        return content;
    }
}

