/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.handler;

import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.customize.StaticFilesSecurity;
import org.rapidoid.http.handler.AbstractHttpHandler;
import org.rapidoid.http.impl.RouteOptions;
import org.rapidoid.http.impl.lowlevel.HttpIO;
import org.rapidoid.io.Res;
import org.rapidoid.log.LogLevel;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.u.U;

public class StaticResourcesHandler
extends AbstractHttpHandler {
    private final Customization customization;

    public StaticResourcesHandler(Customization customization) {
        super(new RouteOptions());
        this.customization = customization;
    }

    @Override
    public HttpStatus handle(Channel ctx, boolean isKeepAlive, Req req, Object extra) {
        if (!HttpUtils.isGetReq(req)) {
            return HttpStatus.NOT_FOUND;
        }
        try {
            byte[] bytes;
            StaticFilesSecurity staticFilesSecurity;
            Res res;
            Object[] staticFilesLocations = this.customization.staticFilesPath();
            if (!U.isEmpty((Object[])staticFilesLocations) && (res = HttpUtils.staticResource(req, (String[])staticFilesLocations)) != null && (staticFilesSecurity = this.customization.staticFilesSecurity()).canServe(req, res) && (bytes = res.getBytesOrNull()) != null) {
                MediaType contentType = (MediaType)U.or((Object)MediaType.getByFileName((String)res.getName()), (Object)MediaType.BINARY);
                HttpIO.INSTANCE.write200(HttpUtils.maybe(req), ctx, isKeepAlive, contentType, bytes);
                return HttpStatus.DONE;
            }
            return HttpStatus.NOT_FOUND;
        }
        catch (Exception e) {
            return HttpIO.INSTANCE.errorAndDone(req, e, LogLevel.ERROR);
        }
    }

    @Override
    public boolean needsParams() {
        return true;
    }
}

