/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.handler;

import java.util.concurrent.Future;
import org.rapidoid.RapidoidThing;
import org.rapidoid.datamodel.Results;
import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.NotFound;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.u.U;

public class HandlerResultProcessor
extends RapidoidThing {
    public static final HandlerResultProcessor INSTANCE = new HandlerResultProcessor();

    public Object postProcessResult(Req req, Object result) {
        if (result instanceof HttpStatus) {
            return result;
        }
        if (result instanceof Req) {
            U.must((req == result ? 1 : 0) != 0, (String)"Unknown request instance was received as result!");
            return this.reqToStatus(req, result);
        }
        if (result instanceof Resp) {
            U.must((req != null && req.response() == result ? 1 : 0) != 0, (String)"Unknown response instance was received as result!");
            return this.reqToStatus(req, result);
        }
        if (result == null || result instanceof NotFound) {
            return HttpStatus.NOT_FOUND;
        }
        if (result instanceof Future || result instanceof org.rapidoid.concurrent.Future) {
            if (req != null) {
                req.async();
            }
            return HttpStatus.ASYNC;
        }
        if (result instanceof Results) {
            return ((Results)result).all();
        }
        return result;
    }

    private HttpStatus reqToStatus(Req req, Object result) {
        if (req.isAsync()) {
            U.must((result instanceof HttpStatus || result instanceof Req || result instanceof Resp ? 1 : 0) != 0, (String)"Didn't expect a direct result from an asynchronous handler!");
            return HttpStatus.ASYNC;
        }
        return HttpStatus.DONE;
    }
}

