/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import org.rapidoid.RapidoidThing;
import org.rapidoid.u.U;

public class HttpResponseCodes
extends RapidoidThing {
    private static final String[] RESPONSE_CODES = new String[]{"100 Continue", "101 Switching Protocols", "102 Processing", "200 OK", "201 Created", "202 Accepted", "203 Non-Authoritative Information", "204 No Content", "205 Reset Content", "206 Partial Content", "207 Multi-Status", "208 Already Reported", "226 IM Used", "300 Multiple Choices", "301 Moved Permanently", "302 Found", "303 See Other", "304 Not Modified", "305 Use Proxy", "307 Temporary Redirect", "308 Permanent Redirect", "400 Bad Request", "401 Unauthorized", "402 Payment Required", "403 Forbidden", "404 Not Found", "405 Method Not Allowed", "406 Not Acceptable", "407 Proxy Authentication Required", "408 Request Timeout", "409 Conflict", "410 Gone", "411 Length Required", "412 Precondition Failed", "413 Payload Too Large", "414 URI Too Long", "415 Unsupported Media Type", "416 Range Not Satisfiable", "417 Expectation Failed", "421 Misdirected Request", "422 Unprocessable Entity", "423 Locked", "424 Failed Dependency", "426 Upgrade Required", "428 Precondition Required", "429 Too Many Requests", "431 Request Header Fields Too Large", "451 Unavailable For Legal Reasons", "500 Internal Server Error", "501 Not Implemented", "502 Bad Gateway", "503 Service Unavailable", "504 Gateway Timeout", "505 HTTP Version Not Supported", "506 Variant Also Negotiates", "507 Insufficient Storage", "508 Loop Detected", "510 Not Extended", "511 Network Authentication Required"};
    private static final byte[][] RESPONSES = new byte[600][];
    private static final String[] STATUSES = new String[600];
    static volatile boolean ready;

    private static void init(String responseCode) {
        String[] parts = responseCode.split(" ", 2);
        int code = U.num((String)parts[0]);
        String response = "HTTP/1.1 " + responseCode + "\r\n";
        HttpResponseCodes.RESPONSES[code] = response.getBytes();
        HttpResponseCodes.STATUSES[code] = parts[1];
    }

    public static byte[] get(int code) {
        if (RESPONSES[code] != null) {
            return RESPONSES[code];
        }
        throw U.rte((String)("Invalid HTTP response code: " + code));
    }

    public static String status(int code) {
        return STATUSES[code];
    }

    public static void init() {
        while (!ready) {
            U.sleep((long)1L);
        }
    }

    static {
        for (String respCode : RESPONSE_CODES) {
            HttpResponseCodes.init(respCode);
        }
        ready = true;
    }
}

