/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.model.impl;

import org.rapidoid.cls.Cls;
import org.rapidoid.model.Item;
import org.rapidoid.var.impl.AbstractVar;

public class ItemPropertyVar<T>
extends AbstractVar<T> {
    private static final long serialVersionUID = -1208784804459879580L;
    private final Item item;
    private final String property;
    private final boolean readOnly;

    public ItemPropertyVar(String name, Item item, String property, T initValue, boolean readOnly) {
        super(name);
        this.item = item;
        this.property = property;
        this.readOnly = readOnly;
        if (initValue != null) {
            this.set(initValue);
        }
    }

    public T get() {
        return this.item.get(this.property);
    }

    public void doSet(T value) {
        if (!this.readOnly) {
            T oldValue = this.get();
            if (oldValue != null) {
                this.item.set(this.property, Cls.convert(value, oldValue.getClass()));
            } else {
                this.item.set(this.property, value);
            }
        }
    }
}

