/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.html.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.Str;
import org.rapidoid.data.JSON;
import org.rapidoid.html.CustomTag;
import org.rapidoid.html.HTML;
import org.rapidoid.html.Tag;
import org.rapidoid.html.TagWidget;
import org.rapidoid.html.impl.ConstantTag;
import org.rapidoid.html.impl.TagImpl;
import org.rapidoid.html.impl.TagInternals;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.var.Var;

public class TagRenderer
extends RapidoidThing {
    private static final byte[] COMMA_SEP = ", ".getBytes();
    private static final byte[] INDENT = "  ".getBytes();
    private static final byte[] EMIT = "_emit($event, '".getBytes();
    private static final byte[] EMIT_SEP = "', [".getBytes();
    private static final byte[] EMIT_CLOSE = "])".getBytes();
    private static final byte[] _H = " _h=\"".getBytes();
    private static final byte[] EQ_DQUOTES = "=\"".getBytes();
    private static final byte[] LT = "<".getBytes();
    private static final byte[] DQUOTES = "\"".getBytes();
    private static final byte[] LT_SLASH = "</".getBytes();
    private static final byte[] GT = ">".getBytes();
    protected static final TagRenderer INSTANCE = new TagRenderer();

    public static TagRenderer get() {
        return INSTANCE;
    }

    public String toHTML(Object content, Object extra) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.str(content, extra, out);
        return out.toString();
    }

    public void str(Object content, Object extra, OutputStream out) {
        this.str(content, 0, false, extra, out);
    }

    public void str(Object content, int level, boolean inline, Object extra, OutputStream out) {
        if (content == null) {
            return;
        }
        if (content instanceof ConstantTag) {
            ConstantTag constantTag = (ConstantTag)content;
            this.write(out, constantTag.bytes());
            return;
        }
        if (content instanceof Tag) {
            Tag tag = (Tag)content;
            TagInternals tagi = (TagInternals)((Object)tag);
            this.str(tagi.base(), level, inline, extra, out);
            return;
        }
        if (content instanceof TagWidget) {
            TagWidget widget = (TagWidget)content;
            Object widgetContent = widget.render(extra);
            if (widgetContent != null) {
                this.str(widgetContent, level, inline, extra, out);
            }
            return;
        }
        if (content instanceof Object[]) {
            this.join((Object[])content, level, inline, extra, out);
            return;
        }
        if (content instanceof Collection) {
            this.join((Collection)content, level, inline, extra, out);
            return;
        }
        this.indent(out, level, inline);
        this.write(out, HTML.escape(U.str((Object)content)));
    }

    protected void join(Collection<?> items, int level, boolean inline, Object extra, OutputStream out) {
        if (level > 500) {
            return;
        }
        for (Object item : items) {
            if (!inline) {
                this.write(out, Constants.LF_);
            }
            this.str(item, level + 1, inline, extra, out);
        }
    }

    protected void join(Object[] items, int level, boolean inline, Object extra, OutputStream out) {
        for (int i = 0; i < items.length; ++i) {
            if (!inline) {
                this.write(out, Constants.LF_);
            }
            this.str(items[i], level + 1, inline, extra, out);
        }
    }

    public void str(TagImpl tag, int level, boolean inline, Object extra, OutputStream out) {
        String name = HTML.escape(tag.name);
        List<Object> contents = tag.contents;
        this.indent(out, level, inline);
        this.write(out, LT);
        this.write(out, name);
        if (tag._h != null) {
            this.write(out, _H);
            this.attrToStr(out, tag, "_h", tag._h);
            this.write(out, DQUOTES);
        }
        for (Map.Entry<String, String> e : tag.attrs.entrySet()) {
            String attr = e.getKey();
            String value = e.getValue();
            this.writeAttr(tag, out, attr, value);
        }
        for (String attr : tag.battrs) {
            this.writeBAttr(out, attr);
        }
        if (tag.cmd != null) {
            this.write(out, " ng-click");
            this.write(out, EQ_DQUOTES);
            this.write(out, EMIT);
            this.write(out, tag.cmd.name);
            this.write(out, EMIT_SEP);
            for (int i = 0; i < tag.cmd.args.length; ++i) {
                Object arg;
                if (i > 0) {
                    this.write(out, COMMA_SEP);
                }
                String str = (arg = tag.cmd.args[i]) instanceof String ? "'" + Str.sub((String)JSON.stringify((Object)arg), (int)1, (int)-1) + "'" : U.str((Object)arg);
                this.write(out, str);
            }
            this.write(out, EMIT_CLOSE);
            this.write(out, DQUOTES);
        }
        this.write(out, GT);
        if (this.isSingleTag(name)) {
            return;
        }
        if (contents == null || contents.isEmpty()) {
            this.closeTag(out, name);
            return;
        }
        if (inline || this.shouldRenderInline(name, contents)) {
            this.str(contents, level + 1, true, extra, out);
            this.closeTag(out, name);
            return;
        }
        if (contents != null) {
            this.str(contents, level, inline, extra, out);
        }
        this.write(out, Constants.LF_);
        this.indent(out, level, inline);
        this.closeTag(out, name);
    }

    private void writeBAttr(OutputStream out, String attr) {
        this.write(out, Constants.SPACE_);
        this.write(out, HTML.escape(attr));
    }

    private void writeAttr(TagImpl tag, OutputStream out, String attr, String value) {
        this.writeBAttr(out, attr);
        this.write(out, EQ_DQUOTES);
        this.attrToStr(out, tag, attr, value);
        this.write(out, DQUOTES);
    }

    private void closeTag(OutputStream out, String name) {
        this.write(out, LT_SLASH);
        this.write(out, name);
        this.write(out, GT);
    }

    protected boolean isSingleTag(String name) {
        return name.equals("input") || name.equals("br") || name.equals("link") || name.equals("img");
    }

    protected void attrToStr(OutputStream out, TagImpl tag, String attr, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            this.write(out, U.join((String)" ", (Object[])arr));
            return;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            this.write(out, U.join((String)" ", (Iterable)coll));
            return;
        }
        this.write(out, HTML.escape(value.toString()));
    }

    protected boolean shouldRenderInline(String name, Object content) {
        if (this.isSimpleContent(content)) {
            return true;
        }
        if (content instanceof Object[]) {
            return this.hasSimpleContent((Object[])content);
        }
        if (content instanceof Collection) {
            return this.hasSimpleContent((Collection)content);
        }
        return false;
    }

    protected boolean isSimpleContent(Object content) {
        if (content instanceof Var) {
            Var var = (Var)content;
            return this.isSimpleContent(var.get());
        }
        if (content instanceof ConstantTag) {
            return true;
        }
        return !Cls.instanceOf((Object)content, (Class[])new Class[]{Tag.class, CustomTag.class, TagWidget.class, Object[].class, Collection.class});
    }

    protected boolean hasSimpleContent(Collection<?> content) {
        for (Object cnt : content) {
            if (!this.isSimpleContent(cnt)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSimpleContent(Object[] content) {
        for (Object cnt : content) {
            if (!this.isSimpleContent(cnt)) continue;
            return true;
        }
        return false;
    }

    protected void write(OutputStream out, byte[] bytes) {
        try {
            out.write(bytes);
        }
        catch (IOException e) {
            throw U.rte((String)"Cannot render tag!", (Throwable)e);
        }
    }

    protected void write(OutputStream out, String s) {
        this.write(out, s.getBytes());
    }

    protected void indent(OutputStream out, int level, boolean inline) {
        if (!inline) {
            for (int i = 0; i < level; ++i) {
                this.write(out, INDENT);
            }
        }
    }
}

