/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui.input;

import java.util.List;
import org.rapidoid.commons.AnyObj;
import org.rapidoid.commons.Err;
import org.rapidoid.gui.Btn;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.base.AbstractWidget;
import org.rapidoid.gui.input.Field;
import org.rapidoid.gui.input.FormMode;
import org.rapidoid.html.FormLayout;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.FormTag;
import org.rapidoid.model.Item;
import org.rapidoid.model.Property;
import org.rapidoid.u.U;

public class Form
extends AbstractWidget<Form> {
    protected final Item item;
    protected final FormMode mode;
    protected List<Property> props;
    protected List<Field> fields = U.list();
    protected List<Btn> buttons;
    protected FormLayout layout = FormLayout.VERTICAL;
    protected boolean hasFields = false;

    public Form(FormMode mode, Item item, String ... properties) {
        this.mode = mode;
        this.item = item;
        this.init(item, properties);
    }

    public int fieldIndex(String fieldName) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!U.eq((Object)this.fields.get((int)i).name, (Object)fieldName)) continue;
            return i;
        }
        throw U.rte((String)"Cannot find field '%s'!", (Object[])new Object[]{fieldName});
    }

    public Form field(String fieldName, Field field) {
        return this.field(this.fieldIndex(fieldName), field);
    }

    public Form field(int fieldIndex, Field field) {
        this.fields.set(fieldIndex, field);
        return this;
    }

    public Field field(String fieldName) {
        return this.field(this.fieldIndex(fieldName));
    }

    public Field field(int fieldIndex) {
        return this.fields.get(fieldIndex);
    }

    public Form buttons(Btn ... buttons) {
        this.buttons = AnyObj.withoutNulls((Object[])buttons);
        return this;
    }

    public List<Btn> buttons() {
        return this.buttons;
    }

    public Form add(Field field) {
        if (field.mode() == null) {
            field.mode(this.mode);
        }
        if (field.layout() == null) {
            field.layout(this.layout);
        }
        this.fields.add(field);
        return this;
    }

    protected void init(Item item, String ... properties) {
        this.props = this.editable() ? item.editableProperties(properties) : item.readableProperties(properties);
        int propN = this.props.size();
        for (int i = 0; i < propN; ++i) {
            Property prop = this.props.get(i);
            Field field = GUI.field(item, prop).mode(this.mode).layout(this.layout);
            this.fields.add(field);
        }
    }

    protected boolean editable() {
        return this.mode != FormMode.SHOW;
    }

    protected void initPermissions() {
    }

    @Override
    protected FormTag render() {
        this.initPermissions();
        FormTag form = this.emptyForm();
        form = this.addFormFields(form);
        form = (FormTag)form.append(this.formButtons());
        return form;
    }

    protected FormTag addFormFields(FormTag form) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.getField(i);
            if (field == null) continue;
            form = (FormTag)form.append(field);
            this.hasFields = true;
        }
        if (!this.hasFields) {
            form = (FormTag)form.append(this.noFormFields());
        }
        return form;
    }

    protected Tag noFormFields() {
        return Form.div("No details are available!");
    }

    protected Field getField(int index) {
        Field field = this.fields.get(index);
        if (field != null) {
            return field.isFieldAllowed() ? field : null;
        }
        return null;
    }

    protected FormTag emptyForm() {
        return (FormTag)((FormTag)GUI.form(new Object[0]).class_(this.formLayoutClass(this.layout))).role("form");
    }

    protected Tag formButtons() {
        Tag btns = this.layout == FormLayout.HORIZONTAL ? Form.div(new Object[0]).class_("col-sm-offset-4 col-sm-8") : Form.div(new Object[0]).class_("form-group");
        if (this.buttons != null && this.hasFields) {
            for (Btn btn : this.buttons) {
                btns = btns.append(btn);
            }
        }
        if (this.layout == FormLayout.HORIZONTAL) {
            return Form.div(btns).class_("form-group");
        }
        return btns;
    }

    protected String formLayoutClass(FormLayout layout) {
        switch (layout) {
            case VERTICAL: {
                return "";
            }
            case HORIZONTAL: {
                return "form-horizontal";
            }
            case INLINE: {
                return "form-inline";
            }
        }
        throw Err.notExpected();
    }
}

