/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui.input;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import org.rapidoid.annotation.Programmatic;
import org.rapidoid.annotation.Required;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Metadata;
import org.rapidoid.cls.Cls;
import org.rapidoid.cls.TypeKind;
import org.rapidoid.commons.Err;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.base.AbstractWidget;
import org.rapidoid.gui.input.Checkbox;
import org.rapidoid.gui.input.Checkboxes;
import org.rapidoid.gui.input.Dropdown;
import org.rapidoid.gui.input.EmailInput;
import org.rapidoid.gui.input.FormMode;
import org.rapidoid.gui.input.MultiSelect;
import org.rapidoid.gui.input.PasswordInput;
import org.rapidoid.gui.input.Radios;
import org.rapidoid.gui.input.TextArea;
import org.rapidoid.gui.input.TextInput;
import org.rapidoid.gui.reqinfo.IReqInfo;
import org.rapidoid.html.FieldType;
import org.rapidoid.html.FormLayout;
import org.rapidoid.html.Tag;
import org.rapidoid.model.Item;
import org.rapidoid.model.Models;
import org.rapidoid.model.Property;
import org.rapidoid.u.U;
import org.rapidoid.var.Var;
import org.rapidoid.var.Vars;

public class Field
extends AbstractWidget<Field> {
    protected volatile FormMode mode = FormMode.EDIT;
    protected volatile Item item;
    protected volatile Property prop;
    protected volatile FormLayout layout = FormLayout.VERTICAL;
    protected volatile String name;
    protected volatile String desc;
    protected volatile FieldType type;
    protected volatile Collection<?> options;
    protected volatile Boolean required;
    protected volatile Tag content;
    protected volatile Tag label;
    protected volatile Tag input;

    public Field(Item item, Property prop) {
        this.item = item;
        this.prop = prop;
    }

    protected boolean isFieldRequired(Property prop) {
        return prop.type().isPrimitive() || Metadata.has((Annotation[])prop.annotations(), Required.class);
    }

    private static Var<Object> initVar(Item item, Property prop, FormMode mode, boolean required) {
        IReqInfo req;
        Object value;
        Object target = U.or((Object)item.value(), (Object)item);
        String varName = Field.propVarName(target, prop.name());
        boolean isReadOnly = mode == FormMode.SHOW;
        Var var = Models.propertyVar(varName, item, prop.name(), null, isReadOnly);
        if (mode != FormMode.SHOW && required) {
            var = Vars.mandatory(var);
        }
        if ((value = (req = Field.req()).data().get(varName)) != null || !req.isGetReq()) {
            var.set(value);
        }
        return var;
    }

    protected Tag field() {
        Tag inputWrap;
        Boolean required;
        Collection<?> options;
        String name = this.prop.name();
        String desc = (String)U.or((Object)this.desc, (Object)this.prop.caption(), (Object)name);
        FieldType type = this.type;
        if (type == null) {
            FieldType fieldType = type = this.mode != FormMode.SHOW ? this.getPropertyFieldType(this.prop) : FieldType.LABEL;
        }
        if ((options = this.options) == null) {
            options = this.getPropertyOptions(this.prop);
        }
        if ((required = this.required()) == null) {
            required = this.isFieldRequired(this.prop);
        }
        Var<Object> var = Field.initVar(this.item, this.prop, this.mode, required);
        desc = (String)U.or((Object)desc, (Object)name) + ": ";
        Tag inp = this.input == null ? this.input_(name, desc, type, options, var) : this.input;
        Tag lbl = this.label;
        if (type == FieldType.RADIOS || type == FieldType.CHECKBOXES) {
            Tag tag = inp = this.layout == FormLayout.VERTICAL ? Field.div(inp) : Field.span(inp);
        }
        if (type == FieldType.CHECKBOX) {
            if (this.label == null) {
                lbl = null;
            }
            inp = Field.div(GUI.label(inp, desc)).class_("checkbox");
            inputWrap = this.layout == FormLayout.HORIZONTAL ? Field.div(inp).class_("col-sm-offset-4 col-sm-8") : inp;
        } else {
            if (this.label == null) {
                lbl = this.layout != FormLayout.INLINE ? GUI.label(desc) : (type == FieldType.RADIOS ? GUI.label(desc) : null);
            }
            if (this.layout == FormLayout.HORIZONTAL && lbl != null) {
                lbl = lbl.class_("col-sm-4 control-label");
            }
            inputWrap = this.layout == FormLayout.HORIZONTAL ? Field.div(inp).class_("col-sm-8") : inp;
        }
        boolean hasErrors = U.notEmpty((Collection)var.errors());
        Tag err = hasErrors ? Field.span(U.join((String)", ", (Iterable)var.errors())).class_("field-error") : null;
        Tag group = lbl != null ? Field.div(lbl, inputWrap, err) : Field.div(inputWrap, err);
        group = group.class_(hasErrors ? "form-group with-validation-errors" : "form-group");
        if (hasErrors) {
            group = group.attr("data-has-validation-errors", "yes");
            GUI.markValidationErrors();
        }
        return group;
    }

    protected Object input_(String name, String desc, FieldType type, Collection<?> options, Var<?> var) {
        switch (type) {
            case TEXT: {
                return this.textInput(name, desc, var);
            }
            case PASSWORD: {
                return this.passwordInput(name, desc, var);
            }
            case EMAIL: {
                return this.emailInput(name, desc, var);
            }
            case TEXTAREA: {
                return this.textareaInput(name, desc, var);
            }
            case CHECKBOX: {
                return this.checkboxInput(name, var);
            }
            case DROPDOWN: {
                return this.dropdownInput(name, options, var);
            }
            case MULTI_SELECT: {
                return this.multiSelectInput(name, options, var);
            }
            case RADIOS: {
                return this.radiosInput(name, options, var);
            }
            case CHECKBOXES: {
                return this.checkboxesInput(name, options, var);
            }
            case LABEL: {
                return this.readonly(var);
            }
        }
        throw Err.notExpected();
    }

    protected Tag readonly(Object item) {
        Object display = GUI.display(item);
        return Field.div(display).class_("display-wrap");
    }

    protected Object checkboxesInput(String name, Collection<?> options, Var<?> var) {
        return ((Checkboxes)((Checkboxes)GUI.checkboxes().name(name)).options(options)).var(var);
    }

    protected Object radiosInput(String name, Collection<?> options, Var<?> var) {
        return ((Radios)((Radios)GUI.radios().name(name)).options(options)).var(var);
    }

    protected Object multiSelectInput(String name, Collection<?> options, Var<?> var) {
        return ((MultiSelect)((MultiSelect)GUI.multiSelect().options(options)).var(var)).name(name);
    }

    protected Object dropdownInput(String name, Collection<?> options, Var<?> var) {
        return ((Dropdown)((Dropdown)GUI.dropdown().options(options)).var(var)).name(name);
    }

    protected Object checkboxInput(String name, Var<?> var) {
        return ((Checkbox)GUI.checkbox().var(var)).name(name);
    }

    protected Object textareaInput(String name, String desc, Var<?> var) {
        TextArea textarea = (TextArea)((TextArea)GUI.txtbig().var(var)).name(name);
        textarea = this.layout == FormLayout.INLINE ? (TextArea)textarea.placeholder(desc) : textarea;
        return textarea;
    }

    protected Object emailInput(String name, String desc, Var<?> var) {
        EmailInput input = (EmailInput)((EmailInput)GUI.email().var(var)).name(name);
        input = this.layout == FormLayout.INLINE ? (EmailInput)input.placeholder(desc) : input;
        return input;
    }

    protected Object passwordInput(String name, String desc, Var<?> var) {
        PasswordInput input = (PasswordInput)((PasswordInput)GUI.password().var(var)).name(name);
        input = this.layout == FormLayout.INLINE ? (PasswordInput)input.placeholder(desc) : input;
        return input;
    }

    protected Object textInput(String name, String desc, Var<?> var) {
        TextInput input = (TextInput)((TextInput)GUI.txt().var(var)).name(name);
        input = this.layout == FormLayout.INLINE ? (TextInput)input.placeholder(desc) : input;
        return input;
    }

    @Override
    protected Tag render() {
        if (this.content != null) {
            return this.content;
        }
        if (this.isFieldProgrammatic() && this.mode != FormMode.SHOW) {
            return null;
        }
        return this.field();
    }

    protected boolean isFieldProgrammatic() {
        return this.prop != null && Metadata.get((Annotation[])this.prop.annotations(), Programmatic.class) != null;
    }

    protected boolean isFieldAllowed() {
        return true;
    }

    protected FormMode fieldMode() {
        return this.type != FieldType.LABEL ? this.mode : FormMode.SHOW;
    }

    protected FieldType getPropertyFieldType(Property prop) {
        Class<?> type = prop.type();
        if (type == Boolean.class || type == Boolean.TYPE) {
            return FieldType.CHECKBOX;
        }
        if (type.isEnum()) {
            return type.getEnumConstants().length <= 3 ? FieldType.RADIOS : FieldType.DROPDOWN;
        }
        if (prop.name().toLowerCase().contains("email")) {
            return FieldType.EMAIL;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return FieldType.MULTI_SELECT;
        }
        if (Cls.kindOf(type) == TypeKind.UNKNOWN) {
            return FieldType.DROPDOWN;
        }
        return FieldType.TEXT;
    }

    protected Collection<?> getPropertyOptions(Property prop) {
        Class<?> type = prop.type();
        if (type.isEnum()) {
            return U.list((Object[])type.getEnumConstants());
        }
        if (Collection.class.isAssignableFrom(type)) {
            return this.getCollectionPropertyOptions(prop);
        }
        if (Cls.kindOf(type) == TypeKind.UNKNOWN) {
            return Collections.EMPTY_LIST;
        }
        return null;
    }

    protected Collection<?> getCollectionPropertyOptions(Property prop) {
        return this.propertyOptions(prop);
    }

    protected Collection<?> propertyOptions(Property prop) {
        if (prop.genericType() != null) {
            Type[] typeArgs = prop.genericType().getActualTypeArguments();
            return typeArgs.length == 1 ? this.getOptionsOfType(Cls.clazz((Type)typeArgs[0])) : Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection<?> getOptionsOfType(Class<?> clazz) {
        if (Cls.kindOf(clazz) == TypeKind.UNKNOWN && Beany.hasProperty(clazz, (String)"id")) {
            return Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    public static String propVarName(Object target, String name) {
        return name;
    }

    public FormMode mode() {
        return this.mode;
    }

    public Field mode(FormMode mode) {
        this.mode = mode;
        return this;
    }

    public Property prop() {
        return this.prop;
    }

    public Field prop(Property prop) {
        this.prop = prop;
        return this;
    }

    public FormLayout layout() {
        return this.layout;
    }

    public Field layout(FormLayout layout) {
        this.layout = layout;
        return this;
    }

    public String name() {
        return this.name;
    }

    public Field name(String name) {
        this.name = name;
        return this;
    }

    public String desc() {
        return this.desc;
    }

    public Field desc(String desc) {
        this.desc = desc;
        return this;
    }

    public FieldType type() {
        return this.type;
    }

    public Field type(FieldType type) {
        this.type = type;
        return this;
    }

    public Collection<?> options() {
        return this.options;
    }

    public Field options(Collection<?> options) {
        this.options = options;
        return this;
    }

    public Boolean required() {
        return this.required;
    }

    public Field required(Boolean required) {
        this.required = required;
        return this;
    }

    public Tag content() {
        return this.content;
    }

    public Field content(Tag content) {
        this.content = content;
        return this;
    }

    public Tag label() {
        return this.label;
    }

    public Field label(Tag label) {
        this.label = label;
        return this;
    }

    public Tag input() {
        return this.input;
    }

    public Field input(Tag input) {
        this.input = input;
        return this;
    }
}

