/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui.base;

import java.util.Arrays;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.base.AbstractWidget;
import org.rapidoid.gui.reqinfo.IReqInfo;
import org.rapidoid.gui.reqinfo.ReqInfo;
import org.rapidoid.u.U;

public abstract class AbstractCommand<W extends AbstractCommand<?>>
extends AbstractWidget<W> {
    private String command;
    private String[] cmdArgs;
    private Runnable handler;
    private Runnable handlerOnSuccess;
    private Runnable handlerOnError;
    private boolean handled;

    public W command(String cmd, Object ... cmdArgs) {
        this.command = cmd;
        this.cmdArgs = this.strArgs(cmdArgs);
        return (W)this;
    }

    private String[] strArgs(Object[] args) {
        String[] strs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            strs[i] = U.str((Object)args[i]).replace("'", "`");
        }
        return strs;
    }

    public boolean clicked() {
        String event;
        IReqInfo req;
        if (this.command != null && !(req = ReqInfo.get()).isGetReq() && U.notEmpty((String)(event = GUI.getCommand())) && U.eq((Object)event, (Object)this.command)) {
            Object[] args = new Object[this.cmdArgs.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = U.or((Object)req.data().get("_" + i), (Object)"");
            }
            return Arrays.equals(args, this.cmdArgs);
        }
        return false;
    }

    protected void handleEventIfMatching() {
        if (!this.handled && this.hasHandler() && this.clicked()) {
            this.handled = true;
            this.handleAction();
        }
    }

    protected boolean hasHandler() {
        return this.handler != null || this.handlerOnSuccess != null || this.handlerOnError != null;
    }

    private void handleAction() {
        if (this.handler != null) {
            this.handler.run();
        }
        if (!GUI.hasValidationErrors()) {
            if (this.handlerOnSuccess != null) {
                this.handlerOnSuccess.run();
            }
        } else if (this.handlerOnError != null) {
            this.handlerOnError.run();
        }
    }

    public String command() {
        return this.command;
    }

    public Object[] cmdArgs() {
        return this.cmdArgs;
    }

    protected Runnable handler() {
        return this.handler;
    }

    protected AbstractCommand handler(Runnable handler) {
        this.handler = handler;
        return this;
    }

    protected Runnable handlerOnSuccess() {
        return this.handlerOnSuccess;
    }

    protected AbstractCommand handlerOnSuccess(Runnable handlerOnSuccess) {
        this.handlerOnSuccess = handlerOnSuccess;
        return this;
    }

    protected Runnable handlerOnError() {
        return this.handlerOnError;
    }

    protected AbstractCommand handlerOnError(Runnable handlerOnError) {
        this.handlerOnError = handlerOnError;
        return this;
    }
}

