/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui;

import org.rapidoid.commons.Str;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.base.AbstractWidget;
import org.rapidoid.html.Tag;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;

public class Snippet
extends AbstractWidget<Snippet> {
    private static final String JAVA_KEYWORDS = "abstract|continue|for|new|switch|assert|default|goto|package|synchronized|do|if|private|this|break|implements|protected|throw|else|import|public|throws|case|enum|instanceof|return|transient|catch|extends|try|final|interface|static|class|finally|strictfp|volatile|const|native|super|while";
    private static final String PRIMITIVE_TYPES = "void|int|short|char|double|float|long|byte|boolean";
    private static final String tab = "\\t";
    private static final String str1 = "(\"[^\"]*?\")";
    private static final String str2 = "('[^']*?')";
    private static final String num = "(\\d+)";
    private static final String kw = "\\b(abstract|continue|for|new|switch|assert|default|goto|package|synchronized|do|if|private|this|break|implements|protected|throw|else|import|public|throws|case|enum|instanceof|return|transient|catch|extends|try|final|interface|static|class|finally|strictfp|volatile|const|native|super|while)\\b";
    private static final String anno = "(\\@\\w+?)\\b";
    private static final String types = U.frmt((String)"\\b([A-Z]\\w+?|%s)\\b", (Object[])new Object[]{"void|int|short|char|double|float|long|byte|boolean"});
    private static final String regex = "(?:" + U.join((String)"|", (Object[])new String[]{"(\"[^\"]*?\")", "('[^']*?')", "(\\d+)", "\\t", "\\b(abstract|continue|for|new|switch|assert|default|goto|package|synchronized|do|if|private|this|break|implements|protected|throw|else|import|public|throws|case|enum|instanceof|return|transient|catch|extends|try|final|interface|static|class|finally|strictfp|volatile|const|native|super|while)\\b", "(\\@\\w+?)\\b", types}) + ")";
    protected String code;

    public Snippet(String code) {
        this.code = code;
    }

    @Override
    protected Tag render() {
        return GUI.hardcoded("<pre class=\"code-snippet\">" + this.prettify() + "</pre>");
    }

    public static String prettify(String sourceCode, boolean escape) {
        String snippet = escape ? sourceCode.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;") : sourceCode;
        String prim = "|void|int|short|char|double|float|long|byte|boolean|";
        snippet = Str.replace((String)snippet, (String)regex, (Mapper)new Mapper<String[], String>(){

            public String map(String[] src) throws Exception {
                String s = src[0];
                char ch = s.charAt(0);
                if (Character.isUpperCase(ch) || "|void|int|short|char|double|float|long|byte|boolean|".contains("|" + s + "|")) {
                    return "<span class=\"_code_cls\">" + s + "</span>";
                }
                if (ch == '\"' || ch == "'".charAt(0)) {
                    return "<span class=\"_code_str\">" + s + "</span>";
                }
                if (ch == '@') {
                    return "<span class=\"_code_ann\">" + s + "</span>";
                }
                if (Character.isDigit(ch)) {
                    return "<span class=\"_code_num\">" + s + "</span>";
                }
                if (s.equals("\t")) {
                    return "    ";
                }
                return "<span class=\"_code_kw\">" + s + "</span>";
            }
        });
        snippet = snippet.replaceAll("\n(\\s*)(.*)\\s//\\shere", "\n$1<span class=\"important-code\">$2</span>");
        return snippet.trim();
    }

    public String prettify() {
        return Snippet.prettify(this.code, true);
    }
}

