/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui;

import java.util.Map;
import org.rapidoid.cls.Cls;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.base.AbstractWidget;
import org.rapidoid.gui.reqinfo.IReqInfo;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.ATag;
import org.rapidoid.u.U;

public class Pager
extends AbstractWidget<Pager> {
    private final String param;
    private volatile Integer min;
    private volatile Integer max;
    private volatile Integer initial;
    private volatile boolean right;

    public Pager(String param) {
        this.param = param;
    }

    @Override
    protected Tag render() {
        return this.shouldDisplay() ? this.pagination() : Pager.div(new Object[0]);
    }

    protected String pageUri(int pageN) {
        IReqInfo req = Pager.req();
        Map query = U.map(req.params());
        query.put(this.param, pageN + "");
        return GUI.uri(req.path(), query);
    }

    protected boolean shouldDisplay() {
        return this.max == null || this.min == null || this.min < this.max;
    }

    protected Tag pagination() {
        int pageN = this.pageNumber();
        Tag firstLi = null;
        if (this.min != null) {
            ATag first = this.first().href(this.pageUri(this.min));
            firstLi = pageN > this.min ? Pager.li(first) : Pager.li(first.href(null)).class_("disabled");
        }
        Tag lastLi = null;
        if (this.max != null) {
            ATag last = this.last().href(this.pageUri(this.max));
            lastLi = pageN < this.max ? Pager.li(last) : Pager.li(last.href(null)).class_("disabled");
        }
        ATag prev = this.prev().href(this.pageUri(pageN - 1));
        Tag prevLi = this.min == null || pageN > this.min ? Pager.li(prev) : Pager.li(prev.href(null)).class_("disabled");
        ATag current = this.current();
        Tag currentLi = Pager.li(current);
        ATag next = this.next().href(this.pageUri(pageN + 1));
        Tag nextLi = this.max == null || pageN < this.max ? Pager.li(next) : Pager.li(next.href(null)).class_("disabled");
        Tag pagination = GUI.nav(GUI.ul_li(firstLi, prevLi, currentLi, nextLi, lastLi).class_("pagination"));
        if (this.right) {
            pagination = GUI.right(pagination);
        }
        return pagination;
    }

    protected int pageNumber() {
        Integer pageNum = (Integer)Cls.convert((String)Pager.req().params().get(this.param), Integer.class);
        int value = (Integer)U.or((Object)pageNum, (Object)this.initial, (Object)this.min, (Object)1);
        if (this.min != null) {
            value = Math.max(this.min, value);
        }
        if (this.max != null) {
            value = Math.min(this.max, value);
        }
        return value;
    }

    protected ATag first() {
        Object firstIcon = Pager.span(GUI.LAQUO).attr("aria-hidden", "true");
        return Pager.a(firstIcon, Pager.span("First").class_("sr-only"));
    }

    protected ATag prev() {
        Object prevIcon = Pager.span(GUI.LT).attr("aria-hidden", "true");
        return Pager.a(prevIcon, Pager.span("Previous").class_("sr-only"));
    }

    protected ATag current() {
        String pageInfo = "Page " + this.pageNumber();
        if (this.max != null) {
            pageInfo = pageInfo + " of " + this.max;
        }
        return GUI.a_void(pageInfo);
    }

    protected ATag next() {
        Object nextIcon = Pager.span(GUI.GT).attr("aria-hidden", "true");
        return Pager.a(nextIcon, Pager.span("Next").class_("sr-only"));
    }

    protected ATag last() {
        Object lastIcon = Pager.span(GUI.RAQUO).attr("aria-hidden", "true");
        return Pager.a(lastIcon, Pager.span("Last").class_("sr-only"));
    }

    public String param() {
        return this.param;
    }

    public int min() {
        return this.min;
    }

    public Pager min(int min) {
        this.min = min;
        return this;
    }

    public int max() {
        return this.max;
    }

    public Pager max(int max) {
        this.max = max;
        return this;
    }

    public boolean right() {
        return this.right;
    }

    public Pager right(boolean right) {
        this.right = right;
        return this;
    }

    public Integer initial() {
        return this.initial;
    }

    public Pager initial(int initial) {
        this.initial = initial;
        return this;
    }
}

