/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui;

import java.util.Map;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.base.AbstractWidget;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.TableTag;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Mapper;

public class KVGrid
extends AbstractWidget<KVGrid> {
    private final String[] headers = new String[]{"Key", "Value"};
    private Mapper<Object, Object> keyView = null;
    private Mapper<Object, Object> valueView = null;
    private Map<?, ?> map;
    private boolean headless;

    @Override
    protected Object render() {
        if (this.map.isEmpty()) {
            return GUI.NOTHING;
        }
        TableTag tbl = this.headless ? GUI.table_(new Object[0]) : GUI.table_(KVGrid.tr(KVGrid.th(this.headers[0]), KVGrid.th(this.headers[1])));
        for (Map.Entry<?, ?> e : this.map.entrySet()) {
            Object key = e.getKey();
            key = this.keyView != null ? Lmbd.eval(this.keyView, key) : GUI.display(key);
            Object val = e.getValue();
            val = this.valueView != null ? Lmbd.eval(this.valueView, val) : GUI.display(val);
            Tag tr = val != null ? KVGrid.tr(KVGrid.td(key), KVGrid.td(val)) : KVGrid.tr(KVGrid.td(key).colspan("2"));
            tbl = (TableTag)tbl.append(tr);
        }
        return tbl;
    }

    public Map<?, ?> map() {
        return this.map;
    }

    public KVGrid map(Map<?, ?> map) {
        this.map = map;
        return this;
    }

    public String[] headers() {
        return this.headers;
    }

    public KVGrid headers(String keyHeader, String valueHeader) {
        this.headers[0] = keyHeader;
        this.headers[1] = valueHeader;
        return this;
    }

    public Mapper<Object, Object> keyView() {
        return this.keyView;
    }

    public Mapper<Object, Object> valueView() {
        return this.valueView;
    }

    public <FROM, TO> KVGrid keyView(Mapper<FROM, TO> keyView) {
        this.keyView = keyView;
        return this;
    }

    public <FROM, TO> KVGrid valueView(Mapper<FROM, TO> valueView) {
        this.valueView = valueView;
        return this;
    }

    public KVGrid headless(boolean headless) {
        this.headless = headless;
        return this;
    }

    public boolean headless() {
        return this.headless;
    }
}

