/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.base.AbstractWidget;
import org.rapidoid.html.Tag;
import org.rapidoid.u.U;

public class Highlight
extends AbstractWidget<Highlight> {
    private String text;
    private String regex;

    public Highlight(String text, String regex) {
        this.text = text;
        this.regex = regex;
    }

    @Override
    protected Tag render() {
        return this.regex != null ? this.complexHighlight() : this.simpleHighlight();
    }

    protected Tag simpleHighlight() {
        return !U.isEmpty((String)this.text) ? Highlight.span(this.text).class_("highlight") : Highlight.span(this.text);
    }

    protected Tag complexHighlight() {
        List parts = U.list();
        Pattern p = Pattern.compile(this.regex);
        Matcher m = p.matcher(this.text);
        int end = 0;
        while (m.find()) {
            String match = m.group();
            parts.add(this.text.substring(end, m.start()));
            parts.add(GUI.highlight(match));
            end = m.end();
        }
        parts.add(this.text.substring(end));
        return Highlight.span(parts);
    }
}

