/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.beany.Beany;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.AnyObj;
import org.rapidoid.commons.Dates;
import org.rapidoid.commons.English;
import org.rapidoid.commons.Str;
import org.rapidoid.gui.Btn;
import org.rapidoid.gui.BtnMenu;
import org.rapidoid.gui.Card;
import org.rapidoid.gui.Debug;
import org.rapidoid.gui.FA;
import org.rapidoid.gui.Grid;
import org.rapidoid.gui.GuiJpaUtil;
import org.rapidoid.gui.Highlight;
import org.rapidoid.gui.HtmlPage;
import org.rapidoid.gui.I18N;
import org.rapidoid.gui.InfiniteStream;
import org.rapidoid.gui.KVGrid;
import org.rapidoid.gui.Layout;
import org.rapidoid.gui.MultiWidget;
import org.rapidoid.gui.Pager;
import org.rapidoid.gui.Panel;
import org.rapidoid.gui.Snippet;
import org.rapidoid.gui.input.Checkbox;
import org.rapidoid.gui.input.Checkboxes;
import org.rapidoid.gui.input.Dropdown;
import org.rapidoid.gui.input.EmailInput;
import org.rapidoid.gui.input.Field;
import org.rapidoid.gui.input.Form;
import org.rapidoid.gui.input.FormMode;
import org.rapidoid.gui.input.MultiSelect;
import org.rapidoid.gui.input.PasswordInput;
import org.rapidoid.gui.input.Radio;
import org.rapidoid.gui.input.Radios;
import org.rapidoid.gui.input.TextArea;
import org.rapidoid.gui.input.TextInput;
import org.rapidoid.gui.reqinfo.IReqInfo;
import org.rapidoid.gui.reqinfo.ReqInfo;
import org.rapidoid.gui.var.ReqDataVar;
import org.rapidoid.html.HTML;
import org.rapidoid.html.Tag;
import org.rapidoid.html.TagWidget;
import org.rapidoid.html.customtag.ColspanTag;
import org.rapidoid.html.tag.ATag;
import org.rapidoid.html.tag.ButtonTag;
import org.rapidoid.html.tag.FormTag;
import org.rapidoid.html.tag.InputTag;
import org.rapidoid.html.tag.TableTag;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.lambda.Calc;
import org.rapidoid.lambda.ToMap;
import org.rapidoid.log.Log;
import org.rapidoid.model.Item;
import org.rapidoid.model.Models;
import org.rapidoid.model.Property;
import org.rapidoid.render.Render;
import org.rapidoid.security.Role;
import org.rapidoid.timeseries.TimeSeries;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.MscOpts;
import org.rapidoid.util.TUUID;
import org.rapidoid.var.Var;

public abstract class GUI
extends HTML
implements Role {
    public static final Tag NOTHING;
    public static final Tag N_A;
    public static final Tag TRUE;
    public static final Tag FALSE;
    public static final Btn SAVE;
    public static final Btn ADD;
    public static final Btn UPDATE;
    public static final Btn INSERT;
    public static final Btn DELETE;
    public static final Btn YES_DELETE;
    public static final Btn REMOVE;
    public static final Btn DESTROY;
    public static final Btn YES;
    public static final Btn NO;
    public static final Btn OK;
    public static final Btn REFRESH;
    public static final Btn CANCEL;
    public static final Btn BACK;
    public static final Btn EDIT;
    public static final Tag WARN;
    private static final AtomicLong ID_GEN;

    public static TableTag table_(Object ... contents) {
        return (TableTag)GUI.table(contents).class_("table table-striped table-hover");
    }

    public static Tag row(ColspanTag ... cols) {
        return GUI.div(cols).class_("row");
    }

    public static Tag rowSeparated(ColspanTag ... cols) {
        return GUI.row(cols).class_("row row-separated");
    }

    public static Tag row(Object ... contents) {
        return GUI.row(GUI.col12(contents));
    }

    public static Tag columns(Object left, Object right) {
        return GUI.row(GUI.col6(left), GUI.col6(right));
    }

    public static Tag columns(Object left, Object middle, Object right) {
        return GUI.row(GUI.col4(left), GUI.col4(middle), GUI.col4(right));
    }

    public static Tag columns(Object left, Object middleLeft, Object middleRight, Object right) {
        return GUI.row(GUI.col3(left), GUI.col3(middleLeft), GUI.col3(middleRight), GUI.col3(right));
    }

    public static Tag rowSeparated(Object ... contents) {
        return GUI.row(contents).class_("row row-separated");
    }

    public static Tag container(Object ... contents) {
        return GUI.div(contents).class_("container");
    }

    public static Tag containerFluid(Object ... contents) {
        return GUI.div(contents).class_("container-fluid");
    }

    public static Tag icon(String icon) {
        return GUI.span(new Object[0]).class_("icon-" + icon);
    }

    public static Tag glyphicon(String glyphicon) {
        return GUI.span(new Object[0]).class_("glyphicon glyphicon-" + glyphicon);
    }

    public static Tag fa(String fontAwesomeIcon) {
        return GUI.i(new Object[0]).class_("fa fa-" + fontAwesomeIcon);
    }

    public static Tag awesomeFw(String fontAwesomeIcon) {
        return GUI.span(new Object[0]).class_("fa fa-fw fa-" + fontAwesomeIcon);
    }

    public static ATag a_glyph(String glyphicon, Object ... contents) {
        return GUI.a_void(GUI.glyphicon(glyphicon), NBSP, contents);
    }

    public static ATag a_awesome(String fontAwesomeIcon, Object ... contents) {
        return GUI.a_void(GUI.fa(fontAwesomeIcon), NBSP, contents);
    }

    public static Btn btn(Object ... contents) {
        Btn btn = ((Btn)Cls.customizable(Btn.class, (Object[])new Object[0])).contents(contents);
        for (Object content : contents) {
            if (!(content instanceof String)) continue;
            String cmd = (String)content;
            btn = (Btn)btn.command(cmd, new Object[0]);
            break;
        }
        return btn;
    }

    public static BtnMenu btnMenu() {
        return new BtnMenu();
    }

    public static Tag nav_(boolean fluid, boolean inverse, Tag brand, Object[] navbarContent) {
        brand = brand.class_("navbar-brand");
        Tag hdr = GUI.div(GUI.btnCollapse(), brand).class_("navbar-header");
        Tag collapsable = GUI.div(navbarContent).class_("collapse navbar-collapse").id("collapsable");
        Tag cnt = GUI.div(hdr, collapsable).class_(GUI.containerMaybeFluid(fluid));
        String navDefOrInv = inverse ? "navbar-inverse" : "navbar-default";
        return GUI.nav(cnt).class_("navbar " + navDefOrInv).role("navigation");
    }

    public static String containerMaybeFluid(boolean fluid) {
        return fluid ? "container-fluid" : "container";
    }

    public static ButtonTag btnCollapse() {
        ButtonTag btn = GUI.button(GUI.span("Toggle navigation").class_("sr-only"), GUI.icon("bar"), GUI.icon("bar"), GUI.icon("bar"));
        btn = (ButtonTag)((ButtonTag)((ButtonTag)btn.type("button").class_("navbar-toggle collapsed")).attr("data-toggle", "collapse")).attr("data-target", "#collapsable");
        return btn;
    }

    public static Tag navbarMenu(boolean onLeft, int activeIndex, Object ... menuItems) {
        Tag menu = GUI.ul(new Object[0]).class_("nav navbar-nav navbar-" + GUI.leftOrRight(onLeft));
        for (int i = 0; i < menuItems.length; ++i) {
            Object item = menuItems[i];
            Tag li = GUI.li(item);
            if (i == activeIndex) {
                li = li.class_("active");
            }
            menu = menu.append(li);
        }
        return menu;
    }

    public static Tag navbarDropdown(boolean onLeft, Tag menu, Object ... subItems) {
        Tag ul1 = GUI.ul_li(subItems).class_("dropdown-menu").role("menu");
        menu = menu.class_("dropdown-toggle").attr("data-toggle", "dropdown");
        Tag drop1 = GUI.li(menu, ul1).class_("dropdown");
        return GUI.ul(drop1).class_("nav navbar-nav navbar-" + GUI.leftOrRight(onLeft));
    }

    public static Tag menuDivider() {
        return GUI.li(new Object[0]).class_("divider");
    }

    public static FormTag navbarForm(boolean onLeft, Object btnContent, String[] fields, String[] placeholders) {
        U.must((fields.length == placeholders.length ? 1 : 0) != 0, (String)"");
        Tag ctrls = GUI.div(new Object[0]).class_("form-group");
        for (int i = 0; i < fields.length; ++i) {
            InputTag inp = ((InputTag)((InputTag)GUI.input(new Object[0]).type("text").class_("form-control")).name(fields[i]).id("navbar-" + fields[i])).placeholder(placeholders[i]);
            ctrls = ctrls.append(inp);
        }
        ButtonTag btn = ((ButtonTag)GUI.button(btnContent).class_("btn btn-default")).type("submit");
        return (FormTag)GUI.form(ctrls, btn).class_("navbar-form navbar-" + GUI.leftOrRight(onLeft));
    }

    public static FormTag navbarSearchForm(String action) {
        return (FormTag)((FormTag)GUI.navbarForm(false, GUI.fa("search"), GUI.arr("q"), GUI.arr("Search")).attr("action", action)).attr("method", "GET");
    }

    public static Object navbarPage(boolean fluid, Tag brand, Object[] navbarContent, Object pageContent) {
        Tag cont = GUI.div(pageContent).class_(GUI.containerMaybeFluid(fluid));
        Tag navbar = GUI.nav_(fluid, false, brand, navbarContent);
        return GUI.arr(navbar, cont);
    }

    public static Object cleanPage(boolean fluid, Object pageContent) {
        return GUI.div(pageContent).class_(GUI.containerMaybeFluid(fluid));
    }

    private static String leftOrRight(boolean onLeft) {
        return onLeft ? "left" : "right";
    }

    public static Tag caret() {
        return GUI.span(new Object[0]).class_("caret");
    }

    public static Tag jumbotron(Object ... contents) {
        return GUI.div(contents).class_("jumbotron");
    }

    public static Tag well(Object ... contents) {
        return GUI.div(contents).class_("well");
    }

    public static ColspanTag col_(int cols, Object ... contents) {
        return (ColspanTag)GUI.tag(ColspanTag.class, "div", contents).class_("col-md-" + cols);
    }

    public static ColspanTag col1(Object ... contents) {
        return GUI.col_(1, contents);
    }

    public static ColspanTag col2(Object ... contents) {
        return GUI.col_(2, contents);
    }

    public static ColspanTag col3(Object ... contents) {
        return GUI.col_(3, contents);
    }

    public static ColspanTag col4(Object ... contents) {
        return GUI.col_(4, contents);
    }

    public static ColspanTag col5(Object ... contents) {
        return GUI.col_(5, contents);
    }

    public static ColspanTag col6(Object ... contents) {
        return GUI.col_(6, contents);
    }

    public static ColspanTag col7(Object ... contents) {
        return GUI.col_(7, contents);
    }

    public static ColspanTag col8(Object ... contents) {
        return GUI.col_(8, contents);
    }

    public static ColspanTag col9(Object ... contents) {
        return GUI.col_(9, contents);
    }

    public static ColspanTag col10(Object ... contents) {
        return GUI.col_(10, contents);
    }

    public static ColspanTag col11(Object ... contents) {
        return GUI.col_(11, contents);
    }

    public static ColspanTag col12(Object ... contents) {
        return GUI.col_(12, contents);
    }

    public static Tag mid2(Object ... contents) {
        return GUI.row(GUI.col5(new Object[0]), GUI.col2(contents), GUI.col5(new Object[0]));
    }

    public static Tag mid4(Object ... contents) {
        return GUI.row(GUI.col4(new Object[0]), GUI.col4(contents), GUI.col4(new Object[0]));
    }

    public static Tag mid6(Object ... contents) {
        return GUI.row(GUI.col3(new Object[0]), GUI.col6(contents), GUI.col3(new Object[0]));
    }

    public static Tag mid8(Object ... contents) {
        return GUI.row(GUI.col2(new Object[0]), GUI.col8(contents), GUI.col2(new Object[0]));
    }

    public static Tag mid10(Object ... contents) {
        return GUI.row(GUI.col1(new Object[0]), GUI.col10(contents), GUI.col1(new Object[0]));
    }

    public static Btn cmd(String cmd, Object ... args) {
        boolean primary = cmd.startsWith("^");
        boolean danger = cmd.startsWith("!");
        boolean warning = cmd.startsWith("?");
        if (primary || danger || warning) {
            cmd = cmd.substring(1);
        }
        String caption = Str.capitalized((String)cmd);
        Btn btn = GUI.btn(caption);
        if (primary) {
            btn.primary();
        } else if (danger) {
            btn.danger();
        } else if (warning) {
            btn.warning();
        }
        btn.command(cmd, args);
        if (danger || warning) {
            btn.confirm(U.frmt((String)"Please confirm that you want to execute '%s'", (Object[])new Object[]{cmd}));
        }
        return btn;
    }

    public static Btn navigate(String cmd) {
        String caption = Str.capitalized((String)cmd);
        return GUI.btn(caption).go(cmd);
    }

    public static Btn[] cmds(String ... commands) {
        Btn[] cmds = new Btn[commands.length];
        for (int i = 0; i < cmds.length; ++i) {
            cmds[i] = GUI.cmd(commands[i], new Object[0]);
        }
        return cmds;
    }

    public static Tag titleBox(Object ... contents) {
        return GUI.div(contents).class_("title-box");
    }

    public static Tag right(Object ... contents) {
        return GUI.span(contents).class_("pull-right");
    }

    public static Panel panel(Object ... contents) {
        return (Panel)Cls.customizable(Panel.class, (Object[])new Object[]{AnyObj.flat((Object[])contents)});
    }

    public static HtmlPage page(Object ... contents) {
        return (HtmlPage)((Object)Cls.customizable(HtmlPage.class, (Object[])new Object[]{AnyObj.flat((Object[])contents)}));
    }

    public static Grid grid(Iterable<?> items) {
        return ((Grid)Cls.customizable(Grid.class, (Object[])new Object[0])).items(items);
    }

    public static <T> KVGrid grid(Map<?, ?> map) {
        return ((KVGrid)Cls.customizable(KVGrid.class, (Object[])new Object[0])).map(map);
    }

    public static <T> List<Object> grids(Map<String, Map<?, ?>> maps) {
        List grids = U.list();
        for (Map.Entry<String, Map<?, ?>> entry : maps.entrySet()) {
            String key = entry.getKey();
            Map<?, ?> map = entry.getValue();
            grids.add(GUI.h4(GUI.b(key, ":")));
            grids.add(GUI.grid(map));
        }
        return grids;
    }

    public static Pager pager(String param) {
        return (Pager)Cls.customizable(Pager.class, (Object[])new Object[]{param});
    }

    public static Form show(Object bean, String ... properties) {
        return GUI.show(Models.item(bean), properties);
    }

    public static Form show(Item item, String ... properties) {
        return new Form(FormMode.SHOW, item, properties);
    }

    public static Form edit(Object bean, String ... properties) {
        return GUI.edit(Models.item(bean), properties);
    }

    public static Form edit(Item item, String ... properties) {
        return new Form(FormMode.EDIT, item, properties);
    }

    public static Form create(Object bean, String ... properties) {
        return GUI.create(Models.item(bean), properties);
    }

    public static Form create(Item item, String ... properties) {
        return new Form(FormMode.CREATE, item, properties);
    }

    public static Field field(Item item, Property prop) {
        return new Field(item, prop);
    }

    public static <T> Property prop(String name, Calc<T> calc) {
        return Models.property(name, calc);
    }

    public static Item item(Object value) {
        return Models.item(value);
    }

    public static Tag media(Object left, Object title, Object body, String targetUrl) {
        Tag mhead = GUI.h4(title).class_("media-heading");
        Tag mleft = GUI.div(left).class_("media-left");
        Tag mbody = GUI.div(mhead, body).class_("media-body");
        String divClass = targetUrl != null ? "media pointer" : "media";
        String js = targetUrl != null ? U.frmt((String)"goAt('%s');", (Object[])new Object[]{targetUrl}) : null;
        return GUI.div(mleft, mbody).class_(divClass).onclick(js);
    }

    public static Tag[] mediaList(List<Object> found) {
        Tag[] items = new Tag[found.size()];
        int ind = 0;
        for (Object result : found) {
            Object id = Beany.getId((Object)result);
            String uri = GUI.uriFor(result);
            Tag left = GUI.h6("(ID", NBSP, "=", NBSP, id, ")");
            Tag header = GUI.span(result.getClass().getSimpleName());
            items[ind++] = GUI.media(left, header, GUI.small(Beany.beanToNiceText((Object)result, (boolean)true)), uri);
        }
        return items;
    }

    public static <T extends Serializable> Var<T> var(String name, Class<T> type, T defaultValue) {
        return new ReqDataVar<T>(name, type, defaultValue);
    }

    public static <T extends Serializable> Var<T> var(String name, T defaultValue) {
        return GUI.var(name, Cls.of(defaultValue), defaultValue);
    }

    public static Var<String> var(String name) {
        return GUI.var(name, String.class, null);
    }

    public static Var<List<String>> listVar(String name) {
        Class type = (Class)U.cast(List.class);
        return new ReqDataVar<List>(name, type, U.list());
    }

    public static Var<List<String>> listVar(String name, List<String> defaultValue) {
        Class type = (Class)U.cast(List.class);
        return new ReqDataVar<List<String>>(name, type, defaultValue);
    }

    public static Object highlight(String text) {
        return GUI.highlight(text, null);
    }

    public static Object highlight(String text, String regex) {
        return Cls.customizable(Highlight.class, (Object[])new Object[]{text, regex});
    }

    public static EmailInput email() {
        return (EmailInput)Cls.customizable(EmailInput.class, (Object[])new Object[0]);
    }

    public static PasswordInput password() {
        return (PasswordInput)Cls.customizable(PasswordInput.class, (Object[])new Object[0]);
    }

    public static TextInput txt() {
        return (TextInput)Cls.customizable(TextInput.class, (Object[])new Object[0]);
    }

    public static TextArea txtbig() {
        return (TextArea)Cls.customizable(TextArea.class, (Object[])new Object[0]);
    }

    public static Checkbox checkbox() {
        return (Checkbox)Cls.customizable(Checkbox.class, (Object[])new Object[0]);
    }

    public static Checkboxes checkboxes() {
        return (Checkboxes)Cls.customizable(Checkboxes.class, (Object[])new Object[0]);
    }

    public static Radio radio() {
        return (Radio)Cls.customizable(Radio.class, (Object[])new Object[0]);
    }

    public static Radios radios() {
        return (Radios)Cls.customizable(Radios.class, (Object[])new Object[0]);
    }

    public static MultiSelect multiSelect() {
        return (MultiSelect)Cls.customizable(MultiSelect.class, (Object[])new Object[0]);
    }

    public static Dropdown dropdown() {
        return (Dropdown)Cls.customizable(Dropdown.class, (Object[])new Object[0]);
    }

    public static Object display(Object item) {
        try {
            return GUI._display(item);
        }
        catch (Exception e) {
            Log.error((String)"Error while rendering GUI element!", (Throwable)e);
            return N_A;
        }
    }

    private static Object _display(Object item) {
        if (item instanceof Tag) {
            return item;
        }
        if (item == null) {
            return N_A;
        }
        if (item instanceof Date) {
            Date date = (Date)item;
            Tag dateSpan = GUI.span(Dates.readable((Date)date));
            return GUI.tooltip(dateSpan, Dates.details((Date)date));
        }
        if (item instanceof Boolean) {
            boolean b = (Boolean)item;
            return b ? TRUE : FALSE;
        }
        if (item instanceof UUID) {
            UUID uuid = (UUID)item;
            return uuid.toString();
        }
        if (item instanceof TUUID) {
            TUUID tuuid = (TUUID)item;
            return tuuid.toString();
        }
        if (item instanceof byte[]) {
            byte[] bytes = (byte[])item;
            return bytes.length <= 512 ? Str.toWebSafeBinary((byte[])bytes) : "(BINARY DATA)";
        }
        if (item instanceof Var) {
            Var var = (Var)item;
            return GUI.display(var.get());
        }
        if (item instanceof Iterable) {
            Iterable iter = (Iterable)item;
            return GUI.display(iter.iterator());
        }
        if (item instanceof Object[]) {
            Object[] arr = (Object[])item;
            return GUI.display(U.iterator((Object[])arr));
        }
        if (item instanceof Map) {
            Map map = (Map)item;
            return GUI.grid(map);
        }
        if (item instanceof ToMap) {
            Map map = ((ToMap)item).toMap();
            return GUI.grid(map);
        }
        if (item instanceof TagWidget) {
            TagWidget widget = (TagWidget)item;
            return widget.render(null);
        }
        if (GUI.isEntity(item)) {
            return GUI.a(GUI.escape(item.toString())).href(GUI.uriFor(item) + "/view");
        }
        if (GUI.isBean(item)) {
            return GUI.show(item, new String[0]);
        }
        String str = GUI.str(item);
        Tag tag = GUI.strTag(str);
        return str.contains("{") || str.contains("}") ? GUI.span(tag).is("ng-non-bindable", true) : tag;
    }

    private static Tag strTag(String str) {
        if (str == null) {
            return N_A;
        }
        int max = 1000;
        if (str.length() < max) {
            return GUI.hardcoded(GUI.escape(str));
        }
        return GUI.tooltip(GUI.span(GUI.hardcoded(GUI.escape(str.substring(0, max))), GUI.b(" ...")), str);
    }

    private static boolean isBean(Object obj) {
        return Cls.isBean((Object)obj) && !(obj instanceof Tag) && !(obj instanceof TagWidget);
    }

    private static Object display(Iterator<?> it) {
        Tag wrap = GUI.div(new Object[0]);
        int count = 0;
        Object item = null;
        while (it.hasNext()) {
            ++count;
            item = it.next();
            wrap = wrap.append(GUI.div(FA.CIRCLE_O, NBSP, GUI.display(item)).class_("value-line"));
        }
        if (count == 0) {
            return GUI.span(NOTHING);
        }
        if (count == 1) {
            return item;
        }
        return wrap;
    }

    public static Object[] spaced(Object ... contents) {
        Object[] arr = new Object[2 * contents.length - 1];
        int index = 0;
        for (int i = 0; i < contents.length; ++i) {
            if (i > 0) {
                arr[index++] = NBSP;
            }
            arr[index++] = contents[i];
        }
        return arr;
    }

    public static Tag inline(Object ... contents) {
        Tag ctrls = GUI.div(GUI.spaced(contents)).class_("form-group");
        return GUI.form(ctrls).class_("form-inline");
    }

    public static Layout layout(Object ... contents) {
        return ((Layout)Cls.customizable(Layout.class, (Object[])new Object[0])).contents(contents);
    }

    public static Layout layout(Iterable<?> contents) {
        return GUI.layout(U.array(contents));
    }

    public static Snippet snippet(String code) {
        return (Snippet)Cls.customizable(Snippet.class, (Object[])new Object[]{code});
    }

    public static InfiniteStream infinite() {
        return (InfiniteStream)Cls.customizable(InfiniteStream.class, (Object[])new Object[0]);
    }

    public static Layout values(Object ... values) {
        List list = U.list();
        for (Object value : values) {
            if (Msc.isArray((Object)value) && !GUI.hasGUIElements(value)) {
                value = U.str((Object)value);
            }
            if (value == null || value instanceof Iterable) {
                value = U.str((Object)value);
            }
            list.add(GUI.row(value));
        }
        return GUI.layout(list);
    }

    private static boolean hasGUIElements(Object value) {
        if (value instanceof Object[]) {
            Object[] arr;
            for (Object val : arr = (Object[])value) {
                if (!(val instanceof TagWidget) && !(val instanceof Tag)) continue;
                return true;
            }
        }
        return false;
    }

    public static Card card(Object ... contents) {
        return ((Card)Cls.customizable(Card.class, (Object[])new Object[0])).contents(contents);
    }

    public static Object i18n(String multiLanguageText, Object ... formatArgs) {
        return new I18N(multiLanguageText, formatArgs);
    }

    public static Btn xClose(String cmd) {
        Object sp1 = GUI.span(GUI.hardcoded("&times;")).attr("aria-hidden", "true");
        Tag sp2 = GUI.span("Close").class_("sr-only");
        return GUI.cmd(cmd, new Object[0]).class_("close").contents(sp1, sp2);
    }

    public static Debug debug() {
        return (Debug)Cls.customizable(Debug.class, (Object[])new Object[0]);
    }

    public static Object box(Object ... contents) {
        return GUI.span(contents).class_("box");
    }

    public static String getCommand() {
        IReqInfo req = GUI.req();
        return !req.isGetReq() ? (String)req.posted().get("_cmd") : null;
    }

    public static boolean isEvent() {
        IReqInfo req = GUI.req();
        return U.eq((Object)req.params().get("__event__"), (Object)"true");
    }

    public static Tag verb(HttpVerb verb) {
        Tag tag = GUI.span(verb);
        switch (verb) {
            case GET: {
                tag = tag.class_("label label-success");
                break;
            }
            case POST: {
                tag = tag.class_("label label-primary");
                break;
            }
            case PUT: {
                tag = tag.class_("label label-warning");
                break;
            }
            case DELETE: {
                tag = tag.class_("label label-danger");
                break;
            }
            default: {
                tag = tag.class_("label label-default");
            }
        }
        return tag;
    }

    public static Tag trTd(Object ... cells) {
        Tag row = GUI.tr(new Object[0]);
        for (Object cell : cells) {
            row = row.append(GUI.td(cell));
        }
        return row;
    }

    public static long newId() {
        return ID_GEN.incrementAndGet();
    }

    public static Object dygraph(String uri, TimeSeries ts, String divClass) {
        List points = U.list();
        NavigableMap values = ts.overview();
        for (Map.Entry e : values.entrySet()) {
            points.add(U.map((Object)"date", e.getKey(), (Object)"values", e.getValue()));
        }
        Map model = U.map((Object[])new Object[]{"points", points, "names", U.list((Object[])new String[]{ts.title()}), "title", ts.title(), "id", GUI.newId(), "class", divClass, "uri", Str.triml((String)uri, (String)"/")});
        Tag graph = GUI.render("dygraphs.html", model);
        return GUI.div(graph);
    }

    public static Object dygraph(String uri, TimeSeries ts) {
        return GUI.dygraph(uri, ts, "rapidoid-dygraph");
    }

    public static String uri(String ... parts) {
        return ReqInfo.get().contextPath() + Msc.uri((String[])parts);
    }

    public static String uriFor(Object target) {
        if (!GUI.isEntity(target)) {
            return "";
        }
        String typeUri = GUI.typeUri(target.getClass());
        return GUI.uriFor(typeUri, target);
    }

    public static String uriFor(String baseUri, Object target) {
        if (!GUI.isEntity(target)) {
            return "";
        }
        Object id = GUI.getIdentifier(target);
        return id != null ? Msc.uri((String[])new String[]{baseUri, id + ""}) : "";
    }

    public static String typeUri(Class<?> entityType) {
        return GUI.typeUri(entityType.getSimpleName());
    }

    public static String typeUri(String entityType) {
        return GUI.uri(English.plural((String)Str.uncapitalized((String)entityType)).toLowerCase());
    }

    private static IReqInfo req() {
        return ReqInfo.get();
    }

    public static void markValidationErrors() {
        GUI.req().attrs().put("has-validation-errors", true);
    }

    public static boolean hasValidationErrors() {
        return Boolean.TRUE.equals(GUI.req().attrs().get("has-validation-errors"));
    }

    private static boolean isEntity(Object item) {
        return MscOpts.hasRapidoidJPA() && GuiJpaUtil.isEntity(item);
    }

    private static Object getIdentifier(Object bean) {
        return MscOpts.hasRapidoidJPA() ? GuiJpaUtil.getIdentifier(bean) : null;
    }

    public static String uri(String path, Map<String, String> query) {
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        boolean first = true;
        for (Map.Entry<String, String> e : query.entrySet()) {
            if (first) {
                sb.append("?");
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(Msc.urlEncode((String)e.getKey()));
            sb.append("=");
            sb.append(Msc.urlEncode((String)e.getValue()));
        }
        return GUI.uri(sb.toString());
    }

    public static Tag copy(Object ... content) {
        return GUI.div(content).class_("copy-snippet");
    }

    public static boolean isGUI(Object result) {
        return result instanceof Tag || result instanceof HtmlPage || result instanceof TagWidget;
    }

    public static MultiWidget multi(Object ... elements) {
        return new MultiWidget(elements);
    }

    public static void redirect(String uri) {
        GUI.req().setHeader("X-Rapidoid-Redirect", uri);
    }

    public static Tag tooltip(Tag target, String tooltip) {
        return target.data("toggle", "tooltip").data("placement", "top").attr("title", tooltip);
    }

    public static Tag render(String templateFile) {
        return GUI.render(templateFile, U.map());
    }

    public static Tag render(String templateFile, Object model) {
        return GUI.hardcoded(Render.file((String)templateFile).model(model));
    }

    public static Tag breadcrumb(Object ... segments) {
        Tag breadcrumb = GUI.ol(new Object[0]).class_("breadcrumb");
        for (Object segment : segments) {
            breadcrumb = breadcrumb.append(GUI.li(GUI.a_void(segment)));
        }
        return breadcrumb;
    }

    public static Tag breadcrumb(Map<?, String> segments) {
        Tag breadcrumb = GUI.ol(new Object[0]).class_("breadcrumb");
        for (Map.Entry<?, String> e : segments.entrySet()) {
            breadcrumb = breadcrumb.append(GUI.li(GUI.a(e.getKey()).href(e.getValue())));
        }
        return breadcrumb;
    }

    public static Tag autoRefresh(long intervalMs) {
        return GUI.script(U.frmt((String)"Rapidoid.setAutoRefreshInterval(%s);", (Object[])new Object[]{intervalMs}));
    }

    public static Object details(Object item) {
        return GUI.mid6(GUI.show(item, new String[0]));
    }

    static {
        N_A = NOTHING = GUI.span(GUI.fa("ban"), " N/A").class_("nothing");
        TRUE = GUI.fa("check-square-o");
        FALSE = GUI.fa("square-o");
        SAVE = GUI.cmd("^Save", new Object[0]);
        ADD = GUI.cmd("^Add", new Object[0]);
        UPDATE = GUI.cmd("^Update", new Object[0]);
        INSERT = GUI.cmd("^Insert", new Object[0]);
        DELETE = GUI.cmd("!Delete", new Object[0]);
        YES_DELETE = GUI.cmd("!YesDelete", new Object[0]).contents("Yes, delete!");
        REMOVE = GUI.cmd("!Remove", new Object[0]);
        DESTROY = GUI.cmd("!Destroy", new Object[0]);
        YES = GUI.cmd("^Yes", new Object[0]);
        NO = GUI.cmd("No", new Object[0]);
        OK = GUI.cmd("^OK", new Object[0]);
        REFRESH = GUI.cmd("refresh", new Object[0]);
        CANCEL = GUI.navigate("Cancel");
        BACK = GUI.navigate("Back");
        EDIT = GUI.cmd("^Edit", new Object[0]);
        WARN = FA.WARNING.style("color: #955; padding-bottom: 23px;");
        ID_GEN = new AtomicLong();
    }
}

