/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.gui;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.base.AbstractWidget;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.ButtonTag;
import org.rapidoid.u.U;

public class BtnMenu
extends AbstractWidget<BtnMenu> {
    private String title;
    private List<Map<Object, String>> menuItems = U.list();

    public BtnMenu() {
        this.menuItems.add(new LinkedHashMap());
    }

    public void addMenuItem(String text, String url) {
        this.menuItems.get(this.menuItems.size() - 1).put(text, url);
    }

    public void addSeparator() {
        this.menuItems.add(new LinkedHashMap());
    }

    private Tag generateButtonHtmlContent() {
        Tag span = BtnMenu.span(new Object[0]).class_("caret");
        return ((ButtonTag)((ButtonTag)((ButtonTag)((ButtonTag)GUI.button(new Object[0]).type("button").class_("btn btn-default dropdown-toggle")).attr("data-toggle", "dropdown")).attr("aria-haspopup", "true")).attr("aria-expanded", "false")).contents(this.title + " ", span);
    }

    private Tag generateMenuHtmlContent() {
        if (!this.menuItems.get(0).isEmpty()) {
            List content = U.list();
            Iterator<Map<Object, String>> iterator = this.menuItems.iterator();
            while (iterator.hasNext()) {
                this.generateMenuItems(content, iterator);
                if (!iterator.hasNext()) continue;
                content.add(BtnMenu.li(new Object[0]).role("separator").class_("divider"));
            }
            return GUI.ul(new Object[0]).class_("dropdown-menu").contents(content);
        }
        return GUI.ul(new Object[0]).class_("dropdown-menu");
    }

    private void generateMenuItems(List<Tag> content, Iterator<Map<Object, String>> subMenuIterator) {
        for (Map.Entry<Object, String> menuItem : subMenuIterator.next().entrySet()) {
            Object a = BtnMenu.a(new Object[0]).href(menuItem.getValue()).contents(menuItem.getKey());
            Object li = BtnMenu.li(new Object[0]).contents(a);
            content.add((Tag)li);
        }
    }

    @Override
    public String toString() {
        return this.render();
    }

    @Override
    public String render() {
        List content = U.list();
        content.add(this.generateButtonHtmlContent());
        Tag menuContent = this.generateMenuHtmlContent();
        content.add(menuContent);
        return BtnMenu.div(new Object[0]).class_("btn-group").contents(content).toString();
    }

    public String title() {
        return this.title;
    }

    public BtnMenu title(String title) {
        this.title = title;
        return this;
    }

    public List<Map<Object, String>> items() {
        return this.menuItems;
    }

    public BtnMenu items(Map<Object, String> items) {
        this.menuItems.add(items);
        return this;
    }
}

