/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.var.impl;

import java.util.Set;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.log.Log;
import org.rapidoid.var.Var;
import org.rapidoid.var.impl.DecoratorVar;

public class ValidatingVar<T>
extends DecoratorVar<T> {
    private final Predicate<T> isValid;
    private final String message;

    public ValidatingVar(Var<T> var, Predicate<T> isValid, String message) {
        super(var);
        this.isValid = isValid;
        this.message = message;
        this.validate(this.get());
    }

    @Override
    public Set<String> errors() {
        return super.errors();
    }

    @Override
    protected void doSet(T value) {
        this.var.set(value);
        this.validate(value);
    }

    private boolean validate(T value) {
        boolean valid;
        try {
            valid = Lmbd.eval(this.isValid, value);
        }
        catch (Exception e) {
            Log.error((String)"Validator failed!", (Throwable)e);
            this.errors().add("Invalid value!");
            return false;
        }
        if (!valid) {
            this.errors().add(this.message);
        }
        return valid;
    }
}

