/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.rapidoid.collection.AbstractListDecorator;

public class SlidingWindowList<E>
extends AbstractListDecorator<E> {
    private final int maxSize;
    private final double stretchingFactor;

    public SlidingWindowList(int maxSize) {
        this(maxSize, 1.1);
    }

    public SlidingWindowList(int maxSize, double stretchingFactor) {
        super(new ArrayList());
        this.maxSize = maxSize;
        this.stretchingFactor = stretchingFactor;
    }

    @Override
    public boolean add(E element) {
        boolean ret = super.add(element);
        this.truncateIfTooBig();
        return ret;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.truncateIfTooBig();
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        boolean ret = super.addAll(elements);
        this.truncateIfTooBig();
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elements) {
        boolean ret = super.addAll(index, elements);
        this.truncateIfTooBig();
        return ret;
    }

    private void truncateIfTooBig() {
        int size = this.size();
        if ((double)size >= (double)this.maxSize * (1.0 + this.stretchingFactor)) {
            this.decorated = new ArrayList(((List)this.decorated).subList(size - this.maxSize, size));
        }
    }
}

