/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.test;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.rapidoid.RapidoidModule;
import org.rapidoid.RapidoidModules;
import org.rapidoid.annotation.IntegrationTest;
import org.rapidoid.beany.Metadata;
import org.rapidoid.env.Env;
import org.rapidoid.log.Log;
import org.rapidoid.test.RapidoidTest;
import org.rapidoid.util.Msc;

public abstract class RapidoidIntegrationTest
extends RapidoidTest {
    @Before
    public final void beforeRapidoidTest() {
        Log.info((String)"--------------------------------------------------------------------------------");
        Log.info((String)("@" + Msc.processId() + " TEST " + ((Object)((Object)this)).getClass().getCanonicalName()));
        Log.info((String)"--------------------------------------------------------------------------------");
        this.clearErrors();
        this.isTrue(Msc.isInsideTest());
        this.isTrue(Env.test());
        RapidoidIntegrationTest.before((Object)this);
        RapidoidIntegrationTest.start((Object)this);
    }

    @After
    public final void afterRapidoidTest() {
        RapidoidIntegrationTest.after((Object)this);
        if (this.hasError()) {
            Assert.fail((String)"Assertion error(s) occurred, probably were caught or were thrown on non-main thread!");
        }
    }

    public static void before(Object test) {
        Msc.logSection("INITIALIZE");
        for (RapidoidModule mod : RapidoidModules.getAllAvailable()) {
            Log.debug((String)"Initializing module before the test", (String)"module", (Object)mod.name(), (String)"order", (Object)mod.order());
            mod.beforeTest(test);
        }
        Log.debug((String)"All modules are initialized");
    }

    public static void start(Object test) {
        RapidoidIntegrationTest.runMainClass(test);
        for (RapidoidModule mod : RapidoidModules.getAllAvailable()) {
            Log.debug((String)"Initializing the test", (String)"module", (Object)mod.name(), (String)"order", (Object)mod.order());
            mod.initTest(test);
        }
        Msc.logSection("START TEST");
    }

    private static void runMainClass(Object test) {
        IntegrationTest testInfo = Metadata.getAnnotationRecursive(test.getClass(), IntegrationTest.class);
        if (testInfo != null) {
            Msc.logSection("RUN MAIN");
            Class<?> main = testInfo.main();
            String[] args = testInfo.args();
            Msc.invokeMain(main, args);
        }
    }

    public static void after(Object test) {
        Msc.logSection("END TEST");
        for (RapidoidModule mod : RapidoidModules.getAllAvailable()) {
            mod.afterTest(test);
        }
        Msc.logSection("FINISHED");
    }
}

