/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Arr;
import org.rapidoid.commons.RapidoidInfo;
import org.rapidoid.group.AbstractManageable;
import org.rapidoid.group.ManageableBean;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Operation;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.process.ProcessCrawlerThread;
import org.rapidoid.process.ProcessIOThread;
import org.rapidoid.process.ProcessParams;
import org.rapidoid.process.Processes;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.SlidingWindowList;
import org.rapidoid.util.Wait;

@ManageableBean(kind="processes")
public class ProcessHandle
extends AbstractManageable {
    private static final Set<ProcessHandle> ALL = Coll.synchronizedSet(new ProcessHandle[0]);
    private static final ProcessCrawlerThread CRAWLER = new ProcessCrawlerThread(ALL);
    private final ProcessParams params;
    private final String id;
    private final BlockingQueue<Object> input = new ArrayBlockingQueue<Object>(100);
    private final BlockingQueue<String> output = null;
    private final BlockingQueue<String> error = null;
    private final List<String> outBuffer;
    private final List<String> errBuffer;
    private final List<String> outAndErrBuffer;
    private final AtomicBoolean doneReadingOut = new AtomicBoolean();
    private final AtomicBoolean doneReadingErr = new AtomicBoolean();
    private final int terminationTimeout;
    private volatile Process process;
    private volatile Date startedAt;
    private volatile Date finishedAt;

    private static void terminateProcesses() {
        for (ProcessHandle proc : Coll.copyOf(ALL)) {
            proc.terminate();
        }
    }

    ProcessHandle(ProcessParams params) {
        this.params = params;
        this.id = params.id() != null ? params.id() : UUID.randomUUID().toString();
        this.outBuffer = Collections.synchronizedList(new SlidingWindowList(params.maxLogLines()));
        this.errBuffer = Collections.synchronizedList(new SlidingWindowList(params.maxLogLines()));
        this.outAndErrBuffer = Collections.synchronizedList(new SlidingWindowList(params.maxLogLines()));
        this.terminationTimeout = params.terminationTimeout();
        ALL.add(this);
        if (params.group() != null) {
            params.group().add(this);
        }
        this.setupIO();
    }

    private void setupIO() {
        ProcessIOThread inputProcessor = new ProcessIOThread(this){

            @Override
            void doIO() {
                ProcessHandle.writeAll(ProcessHandle.this.input, ProcessHandle.this.process.getOutputStream());
            }
        };
        inputProcessor.setDaemon(true);
        inputProcessor.start();
        ProcessIOThread errorProcessor = new ProcessIOThread(this){

            @Override
            void doIO() {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(ProcessHandle.this.process.getErrorStream()));
                    ProcessHandle.this.readInto(reader, ProcessHandle.this.error, new List[]{ProcessHandle.this.errBuffer, ProcessHandle.this.outAndErrBuffer});
                }
                finally {
                    ProcessHandle.this.doneReadingErr.set(true);
                }
            }
        };
        errorProcessor.setDaemon(true);
        errorProcessor.start();
        ProcessIOThread outputProcessor = new ProcessIOThread(this){

            @Override
            void doIO() {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(ProcessHandle.this.process.getInputStream()));
                    ProcessHandle.this.readInto(reader, ProcessHandle.this.output, new List[]{ProcessHandle.this.outBuffer, ProcessHandle.this.outAndErrBuffer});
                }
                finally {
                    ProcessHandle.this.doneReadingOut.set(true);
                }
            }
        };
        outputProcessor.setDaemon(true);
        outputProcessor.start();
    }

    private static void writeAll(BlockingQueue<Object> input, OutputStream output) {
        while (!Thread.interrupted()) {
            try {
                Object obj = input.take();
                if (obj instanceof String) {
                    String s = (String)obj;
                    output.write(s.getBytes());
                } else if (obj instanceof byte[]) {
                    byte[] b = (byte[])obj;
                    output.write(b);
                } else {
                    throw U.rte((String)("Unsupported input object type: " + obj));
                }
                output.flush();
            }
            catch (Exception e) {
                Log.error((String)"Cannot write!", (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long readInto(BufferedReader reader, BlockingQueue<String> dest, List<String> ... buffers) {
        long total = 0L;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                try {
                    if (dest != null) {
                        dest.put(line);
                    }
                    if (this.params.printingOutput()) {
                        U.print((Object[])new Object[]{this.params.linePrefix() + line});
                    }
                    for (List<String> buffer : buffers) {
                        buffer.add(line);
                    }
                    ++total;
                }
                catch (InterruptedException e) {
                    throw new CancellationException();
                    return total;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return total;
    }

    public synchronized BlockingQueue<Object> input() {
        return this.input;
    }

    public synchronized BlockingQueue<String> output() {
        return this.output;
    }

    public synchronized BlockingQueue<String> error() {
        return this.error;
    }

    public synchronized Process process() {
        return this.process;
    }

    public synchronized ProcessParams params() {
        return this.params;
    }

    public synchronized boolean isAlive() {
        return this.process != null && this.exitCode() == null;
    }

    public void receive(Operation<String> outputProcessor, Operation<String> errorProcessor) {
        int grace = 1;
        do {
            String s;
            if (outputProcessor != null) {
                while ((s = (String)this.output().poll()) != null) {
                    Lmbd.call(outputProcessor, s);
                }
            }
            if (errorProcessor != null) {
                while ((s = (String)this.error().poll()) != null) {
                    Lmbd.call(errorProcessor, s);
                }
            }
            U.sleep((long)10L);
        } while (this.isAlive() || !this.doneReadingOut.get() || !this.doneReadingErr.get() || --grace >= 0);
    }

    public void print() {
        for (String line : this.outAndError()) {
            U.print((Object[])new Object[]{line});
        }
    }

    public void log(LogLevel level) {
        for (String line : this.outAndError()) {
            Log.log((String)"PROCESS", (LogLevel)level, (String)line);
        }
    }

    public List<String> out() {
        return this.outBuffer;
    }

    public List<String> err() {
        return this.errBuffer;
    }

    public List<String> outAndError() {
        return this.outAndErrBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void startProcess(ProcessParams params) {
        Process process;
        Log.info((String)"Starting process", (String)"command", (Object)params.command());
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(params.command());
        if (params.in() != null) {
            builder.directory(params.in());
        }
        this.removeRapidoidConfig(builder.environment());
        this.addExtraEnvInfo(builder.environment());
        Date startingAt = new Date();
        try {
            process = builder.start();
        }
        catch (IOException e) {
            throw U.rte((String)("Cannot start process: " + U.join((String)" ", (Object[])params.command())));
        }
        this.startedAt = startingAt;
        this.finishedAt = null;
        this.doneReadingErr.set(false);
        this.doneReadingOut.set(false);
        this.attach(process);
        ProcessCrawlerThread processCrawlerThread = CRAWLER;
        synchronized (processCrawlerThread) {
            if (CRAWLER.getState() == Thread.State.NEW) {
                CRAWLER.start();
            }
        }
    }

    private void addExtraEnvInfo(Map<String, String> env) {
        env.put("MANAGED_BY", RapidoidInfo.nameAndInfo());
    }

    private void removeRapidoidConfig(Map<String, String> env) {
        Iterator<Map.Entry<String, String>> it = env.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            String key = e.getKey().toUpperCase();
            if (!key.startsWith("RAPIDOID_") && !key.startsWith("RAPIDOID.")) continue;
            it.remove();
        }
    }

    private void attach(Process process) {
        this.process = process;
    }

    private synchronized Process requireProcess() {
        U.must((this.process != null ? 1 : 0) != 0, (String)"The handle must have a process attached!");
        return this.process;
    }

    public ProcessHandle waitFor() {
        try {
            this.requireProcess().waitFor();
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
        Wait.until(this.doneReadingOut);
        Wait.until(this.doneReadingErr);
        return this;
    }

    public ProcessHandle waitFor(long timeout, TimeUnit unit) {
        try {
            this.requireProcess().waitFor(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
        Wait.until(this.doneReadingOut);
        Wait.until(this.doneReadingErr);
        return this;
    }

    public ProcessHandle destroy() {
        if (this.process != null) {
            this.process.destroy();
        }
        return this;
    }

    public ProcessHandle destroyForcibly() {
        if (this.process != null) {
            this.process.destroyForcibly();
        }
        return this;
    }

    public synchronized String cmd() {
        return this.params.command()[0];
    }

    public synchronized String[] args() {
        return Arr.sub(this.params.command(), 1, this.params().command().length);
    }

    public synchronized Integer exitCode() {
        try {
            return this.process != null ? Integer.valueOf(this.process.exitValue()) : null;
        }
        catch (IllegalThreadStateException e) {
            return null;
        }
    }

    public synchronized long duration() {
        if (this.startedAt == null) {
            return 0L;
        }
        Date until = this.finishedAt;
        if (until == null) {
            until = new Date();
        }
        return until.getTime() - this.startedAt.getTime();
    }

    synchronized void onTerminated() {
        this.finishedAt = new Date();
    }

    public synchronized Date startedAt() {
        return this.startedAt;
    }

    public synchronized Date finishedAt() {
        return this.finishedAt;
    }

    @Override
    public synchronized String id() {
        return this.id;
    }

    @Override
    public synchronized List<String> getManageableActions() {
        List actions = U.list((Object[])new String[]{"?Restart"});
        if (this.isAlive()) {
            actions.add("!Terminate");
        }
        return actions;
    }

    public synchronized Processes group() {
        return this.params.group();
    }

    public synchronized ProcessHandle restart() {
        this.terminate();
        this.startProcess(this.params);
        return this;
    }

    public synchronized ProcessHandle terminate() {
        this.destroy();
        long t = U.time();
        while (this.isAlive()) {
            U.sleep((long)1L);
            if (!Msc.timedOut(t, this.terminationTimeout)) continue;
            this.destroyForcibly();
            break;
        }
        t = U.time();
        while (this.isAlive()) {
            U.sleep((long)1L);
            if (!Msc.timedOut(t, this.terminationTimeout)) continue;
            throw U.rte((String)"Couldn't terminate the process!");
        }
        Log.info((String)"Terminated process", (String)"id", (Object)this.id());
        return this;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ProcessHandle.terminateProcesses();
            }
        });
    }
}

