/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import org.rapidoid.RapidoidThing;

public class Stats
extends RapidoidThing {
    private volatile int count;
    private volatile double min;
    private volatile double max;
    private volatile double sum;

    public synchronized void add(double value) {
        this.min = this.count > 0 ? Math.min(this.min, value) : value;
        this.max = this.count > 0 ? Math.max(this.max, value) : value;
        this.sum += value;
        ++this.count;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public double sum() {
        return this.sum;
    }

    public int count() {
        return this.count;
    }

    public double avg() {
        return this.count > 0 ? this.sum / (double)this.count : 0.0;
    }

    public synchronized String toString() {
        return "Stats{count=" + this.count + ", min=" + this.min + ", max=" + this.max + ", sum=" + this.sum + ", avg=" + this.avg() + '}';
    }
}

