/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.commons;

import java.util.Collection;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.collection.AutoExpandingMap;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Err;
import org.rapidoid.lambda.Mapper;

public class Deep
extends RapidoidThing {
    public static Object copyOf(Object source, Mapper<Object, ?> transformation) {
        Err.argMust(source != null, "source cannot be null!", new Object[0]);
        if (Coll.isCollection(source)) {
            return Deep.copyOf((Collection)source, transformation);
        }
        if (Coll.isMap(source)) {
            return Deep.copyOf((Map)source, transformation);
        }
        if (source instanceof Object[]) {
            return Deep.copyOf((Object[])source, transformation);
        }
        try {
            return transformation != null ? transformation.map(source) : source;
        }
        catch (Exception e) {
            throw new RuntimeException("Transformation error!", e);
        }
    }

    public static <T> Collection<T> copyOf(Collection<? extends T> source, Mapper<Object, ?> transformation) {
        Err.argMust(source != null, "source cannot be null!", new Object[0]);
        Collection destination = (Collection)Deep.newInstance(source);
        Deep.copy(destination, source, transformation);
        return destination;
    }

    public static <T> void copy(Collection<T> destination, Collection<? extends T> source, Mapper<Object, ?> transformation) {
        Err.argMust(source != null, "source cannot be null!", new Object[0]);
        Err.argMust(destination != null, "destination cannot be null!", new Object[0]);
        destination.clear();
        for (T el : source) {
            destination.add(Deep.copyOf(el, transformation));
        }
    }

    public static <T> T[] copyOf(T[] source, Mapper<Object, ?> transformation) {
        Err.argMust(source != null, "source cannot be null!", new Object[0]);
        Object[] destination = (Object[])Deep.newInstance(source);
        Deep.copy(destination, source, transformation);
        return destination;
    }

    public static <T> void copy(T[] destination, T[] source, Mapper<Object, ?> transformation) {
        Err.argMust(source != null, "source cannot be null!", new Object[0]);
        Err.argMust(destination != null, "destination cannot be null!", new Object[0]);
        Err.argMust(source.length == destination.length, "source and destination arrays must have the same length!", new Object[0]);
        for (int i = 0; i < destination.length; ++i) {
            destination[i] = Deep.copyOf(source[i], transformation);
        }
    }

    public static <K, V> Map<K, V> copyOf(Map<? extends K, ? extends V> source, Mapper<Object, ?> transformation) {
        Err.argMust(source != null, "source cannot be null!", new Object[0]);
        Map destination = (Map)Deep.newInstance(source);
        Deep.copy(destination, source, transformation);
        return destination;
    }

    public static <K, V> void copy(Map<K, V> destination, Map<? extends K, ? extends V> source, Mapper<Object, ?> transformation) {
        Err.argMust(source != null, "source cannot be null!", new Object[0]);
        Err.argMust(destination != null, "destination cannot be null!", new Object[0]);
        destination.clear();
        for (Map.Entry<K, V> e : source.entrySet()) {
            Object key = Deep.copyOf(e.getKey(), transformation);
            Object value = Deep.copyOf(e.getValue(), transformation);
            destination.put(key, value);
        }
    }

    private static <T> T newInstance(Object source) {
        if (source instanceof AutoExpandingMap) {
            AutoExpandingMap autoExpandingMap = (AutoExpandingMap)source;
            return (T)autoExpandingMap.copy();
        }
        return (T)Cls.newInstance(source.getClass());
    }
}

