/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.collection;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.rapidoid.collection.AbstractMapDecorator;
import org.rapidoid.collection.ChangeTrackingCollection;
import org.rapidoid.collection.ChangeTrackingSet;

public class ChangeTrackingMap<K, V>
extends AbstractMapDecorator<K, V> {
    private final AtomicBoolean dirtyFlag;
    private volatile transient Set<Map.Entry<K, V>> entrySet;
    private volatile transient Set<K> keySet;
    private volatile transient Collection<V> values;

    public ChangeTrackingMap(Map<K, V> target, AtomicBoolean dirtyFlag) {
        super(target);
        this.dirtyFlag = dirtyFlag;
    }

    @Override
    public V put(K k, V v) {
        V old = ((Map)this.decorated).put(k, v);
        this.changedIf(old != v);
        return old;
    }

    @Override
    public V remove(Object o) {
        Object removed = ((Map)this.decorated).remove(o);
        this.changedIf(removed != null);
        return removed;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        ((Map)this.decorated).putAll(map);
        this.changedIf(!map.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map map = (Map)this.decorated;
        synchronized (map) {
            if (!((Map)this.decorated).isEmpty()) {
                ((Map)this.decorated).clear();
                this.dirtyFlag.set(true);
            }
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ChangeTrackingSet(super.entrySet(), this.dirtyFlag);
        }
        return this.entrySet;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new ChangeTrackingSet(super.keySet(), this.dirtyFlag);
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ChangeTrackingCollection(super.values(), this.dirtyFlag);
        }
        return this.values;
    }

    private void changedIf(boolean changed) {
        if (changed) {
            this.dirtyFlag.set(true);
        }
    }
}

