/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.beany;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.cls.Cls;
import org.rapidoid.u.U;

public class Metadata
extends RapidoidThing {
    public static Map<Class<?>, Annotation> classAnnotations(Class<?> clazz) {
        clazz = Cls.unproxy(clazz);
        Map annotations = U.map();
        for (Annotation ann : clazz.getAnnotations()) {
            annotations.put(ann.annotationType(), ann);
        }
        return annotations;
    }

    public static <T extends Annotation> T classAnnotation(Class<?> clazz, Class<T> annotationClass) {
        clazz = Cls.unproxy(clazz);
        return (T)Metadata.classAnnotations(clazz).get(annotationClass);
    }

    public static Map<Class<?>, Annotation> methodAnnotations(Method method) {
        Map annotations = U.map();
        for (Annotation ann : method.getAnnotations()) {
            annotations.put(ann.annotationType(), ann);
        }
        return annotations;
    }

    public static <T extends Annotation> T methodAnnotation(Method method, Class<T> annotationClass) {
        return (T)Metadata.methodAnnotations(method).get(annotationClass);
    }

    public static Map<Class<?>, Annotation> propAnnotations(Class<?> clazz, String property) {
        clazz = Cls.unproxy(clazz);
        Map annotations = U.map();
        Prop prop = Beany.property(clazz, property, false);
        if (prop != null) {
            for (Annotation ann : prop.getDeclaringType().getAnnotations()) {
                annotations.put(ann.annotationType(), ann);
            }
            for (Annotation ann : prop.getAnnotations()) {
                annotations.put(ann.annotationType(), ann);
            }
        }
        return annotations;
    }

    public static <T extends Annotation> T propAnnotation(Class<?> clazz, String property, Class<T> annotationClass) {
        clazz = Cls.unproxy(clazz);
        return (T)Metadata.propAnnotations(clazz, property).get(annotationClass);
    }

    public static boolean isAnnotated(Class<?> clazz, Class<? extends Annotation> annotation) {
        clazz = Cls.unproxy(clazz);
        return Metadata.classAnnotations(clazz).containsKey(annotation);
    }

    public static boolean isAnnotatedAny(Class<?> clazz, Collection<Class<? extends Annotation>> annotations) {
        clazz = Cls.unproxy(clazz);
        for (Class<? extends Annotation> ann : annotations) {
            if (!clazz.isAnnotationPresent(ann)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Annotation> T get(Annotation[] annotations, Class<T> annotationClass) {
        if (annotations != null) {
            for (Annotation ann : annotations) {
                if (!annotationClass.isAssignableFrom(ann.annotationType())) continue;
                return (T)ann;
            }
        }
        return null;
    }

    public static boolean has(Annotation[] annotations, Class<? extends Annotation> annotationClass) {
        return Metadata.get(annotations, annotationClass) != null;
    }

    public static boolean hasAny(Annotation[] annotations, Iterable<Class<? extends Annotation>> annotationType) {
        for (Class<? extends Annotation> annType : annotationType) {
            if (!Metadata.has(annotations, annType)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Annotation> T getAnnotationRecursive(Class<?> clazz, Class<T> annotationClass) {
        Class<?> c = clazz = Cls.unproxy(clazz);
        while (c.getSuperclass() != null) {
            T ann = c.getAnnotation(annotationClass);
            if (ann != null) {
                return ann;
            }
            c = c.getSuperclass();
        }
        return null;
    }
}

