/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.data;

import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.commons.Str;
import org.rapidoid.data.BufRange;
import org.rapidoid.data.BufRanges;
import org.rapidoid.data.JSON;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class KeyValueRanges
extends RapidoidThing {
    public final BufRange[] keys;
    public final BufRange[] values;
    public int count;

    public KeyValueRanges(int capacity) {
        this.keys = new BufRange[capacity];
        this.values = new BufRange[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.keys[i] = new BufRange();
            this.values[i] = new BufRange();
            this.keys[i].reset();
            this.values[i].reset();
        }
    }

    public KeyValueRanges reset() {
        for (int i = 0; i < this.count; ++i) {
            this.keys[i].reset();
            this.values[i].reset();
        }
        this.count = 0;
        return this;
    }

    public BufRange get(Buf buf, byte[] key, boolean caseSensitive) {
        for (int i = 0; i < this.count; ++i) {
            if (!BytesUtil.matches(buf.bytes(), this.keys[i], key, caseSensitive)) continue;
            return this.values[i];
        }
        return null;
    }

    public String toString() {
        return super.toString() + "[" + this.count + "]";
    }

    public int max() {
        return this.keys.length;
    }

    public String str(Buf src) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("<");
            sb.append(this.keys[i].str(src.bytes()));
            sb.append(":=");
            sb.append(this.values[i].str(src.bytes()));
            sb.append(">");
        }
        sb.append("]");
        return sb.toString();
    }

    public int add() {
        if (this.count >= this.max()) {
            throw U.rte((String)"too many key-values!");
        }
        return this.count++;
    }

    public Map<String, String> toMap(String data) {
        Map map = U.map();
        for (int i = 0; i < this.count; ++i) {
            map.put(this.keys[i].get(data), this.values[i].get(data));
        }
        return map;
    }

    public void toMap(Buf src, boolean urlDecodeKeys, boolean urlDecodeVals, boolean lowerCaseKeys, Map<String, ? super String> dest) {
        for (int i = 0; i < this.count; ++i) {
            String key = this.keys[i].str(src.bytes());
            String val = this.values[i].str(src.bytes());
            if (urlDecodeKeys) {
                key = Msc.urlDecodeOrKeepOriginal((String)key);
            }
            if (urlDecodeVals) {
                val = Msc.urlDecodeOrKeepOriginal((String)val);
            }
            if (lowerCaseKeys) {
                key = key.toLowerCase();
            }
            dest.put(key, val);
        }
    }

    public Map<String, String> toMap(Buf src, boolean urlDecodeKeys, boolean urlDecodeVals, boolean lowerCaseKeys) {
        Map map = U.map();
        this.toMap(src, urlDecodeKeys, urlDecodeVals, lowerCaseKeys, map);
        return map;
    }

    public void toUrlDecodedParams(Buf src, Map<String, Object> params, BufRanges contentTypes) {
        for (int i = 0; i < this.count; ++i) {
            String key = this.keys[i].str(src.bytes());
            String val = this.values[i].str(src.bytes());
            boolean isJSON = this.isJSON(src, contentTypes, i);
            key = Msc.urlDecodeOrKeepOriginal((String)key);
            if (!isJSON) {
                val = Msc.urlDecodeOrKeepOriginal((String)val);
                if (key.endsWith("[]")) {
                    List list = (List)params.get(key = Str.sub((String)key, (int)0, (int)-2));
                    if (list == null) {
                        list = U.list();
                        params.put(key, list);
                    }
                    list.add(val);
                    continue;
                }
                params.put(key, val);
                continue;
            }
            params.put(key, JSON.parse((String)val));
        }
    }

    private boolean isJSON(Buf src, BufRanges contentTypes, int index) {
        if (contentTypes.count > 0) {
            U.must((contentTypes.count > index ? 1 : 0) != 0);
            BufRange ct = contentTypes.get(index);
            return !ct.isEmpty() && ct.str(src.bytes()).startsWith("application/json");
        }
        return false;
    }

    public Map<String, byte[]> toBinaryMap(Buf src, boolean urlDecodeKeys) {
        Map map = U.map();
        for (int i = 0; i < this.count; ++i) {
            String key = this.keys[i].str(src.bytes());
            byte[] val = this.values[i].bytes(src);
            if (urlDecodeKeys) {
                key = Msc.urlDecodeOrKeepOriginal((String)key);
            }
            map.put(key, val);
        }
        return map;
    }
}

