/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.buffer;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.MultiBuf;
import org.rapidoid.buffer.SynchronizedBuf;
import org.rapidoid.pool.Pool;
import org.rapidoid.pool.Pools;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class BufGroup
extends RapidoidThing {
    private final int factor;
    private final Pool<ByteBuffer> pool;
    private final boolean synchronizedBuffers;

    public BufGroup(final int capacity, boolean synchronizedBuffers) {
        this.synchronizedBuffers = synchronizedBuffers;
        U.must((capacity >= 2 ? 1 : 0) != 0, (String)"The capacity must >= 2!");
        U.must(((capacity & capacity - 1) == 0 ? 1 : 0) != 0, (String)"The capacity must be a power of 2!");
        this.factor = Msc.log2((int)capacity);
        U.must(((double)capacity == Math.pow(2.0, this.factor) ? 1 : 0) != 0);
        this.pool = Pools.create((String)"buffers", (Callable)new Callable<ByteBuffer>(){

            @Override
            public ByteBuffer call() {
                return ByteBuffer.allocateDirect(capacity);
            }
        }, (int)1000);
    }

    public BufGroup(int capacity) {
        this(capacity, true);
    }

    public Buf newBuf(String name) {
        OutputStream buf = new MultiBuf(this.pool, this.factor, name);
        if (this.synchronizedBuffers) {
            buf = new SynchronizedBuf((Buf)((Object)buf));
        }
        return buf;
    }

    public Buf newBuf() {
        return this.newBuf("no-name");
    }

    public Buf from(String s, String name) {
        return this.from(ByteBuffer.wrap(s.getBytes()), name);
    }

    public Buf from(ByteBuffer bbuf, String name) {
        Buf buf = this.newBuf(name);
        buf.append(bbuf);
        return buf;
    }

    public int instances() {
        return this.pool.objectsCreated();
    }

    public void clear() {
        this.pool.clear();
    }
}

