/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api.loader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;
import org.raml.v2.internal.common.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheResourceLoader
implements ResourceLoaderExtended {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Pair<byte[], URI>> resources = new HashMap<String, Pair<byte[], URI>>();
    private ResourceLoader resourceLoader;

    public CacheResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }

    @Override
    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        try {
            InputStream resource;
            if (this.resources.containsKey(resourceName)) {
                byte[] resourceByteArray = this.resources.get(resourceName).getLeft();
                URI uriCallback = this.resources.get(resourceName).getRight();
                if (uriCallback != null && callback != null) {
                    callback.onResourceFound(uriCallback);
                }
                return this.toInputStreamOrNull(resourceByteArray);
            }
            URI uriCallback = null;
            if (this.resourceLoader instanceof ResourceLoaderExtended) {
                resource = ((ResourceLoaderExtended)this.resourceLoader).fetchResource(resourceName, callback);
                uriCallback = ((ResourceLoaderExtended)this.resourceLoader).getUriCallBackParam();
            } else {
                resource = this.resourceLoader.fetchResource(resourceName);
            }
            byte[] resourceByteArray = resource == null ? null : IOUtils.toByteArray((InputStream)resource);
            this.resources.put(resourceName, Pair.of(resourceByteArray, uriCallback));
            return this.toInputStreamOrNull(resourceByteArray);
        }
        catch (IOException e) {
            return this.resourceLoader.fetchResource(resourceName);
        }
    }

    private ByteArrayInputStream toInputStreamOrNull(byte[] resourceByteArray) {
        return resourceByteArray == null ? null : new ByteArrayInputStream(resourceByteArray);
    }

    @Override
    public URI getUriCallBackParam() {
        if (this.resourceLoader != null && this.resourceLoader instanceof ResourceLoaderExtended) {
            return ((ResourceLoaderExtended)this.resourceLoader).getUriCallBackParam();
        }
        return null;
    }
}

