/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.union;

import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.TypeName;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.raml.ramltopojo.Utils;
import org.raml.v2.api.model.v10.datamodel.AnyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.BooleanTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.IntegerTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NullTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class UnionTypesHelper {
    private static Map<Class<? extends TypeDeclaration>, Integer> getPriorityTypeMap() {
        return new ImmutableMap.Builder().put(NullTypeDeclaration.class, (Object)1).put(BooleanTypeDeclaration.class, (Object)2).put(IntegerTypeDeclaration.class, (Object)3).put(NumberTypeDeclaration.class, (Object)4).put(DateTypeDeclaration.class, (Object)5).put(TimeOnlyTypeDeclaration.class, (Object)6).put(DateTimeOnlyTypeDeclaration.class, (Object)7).put(DateTimeTypeDeclaration.class, (Object)8).put(StringTypeDeclaration.class, (Object)9).put(ObjectTypeDeclaration.class, (Object)10).put(ArrayTypeDeclaration.class, (Object)11).put(UnionTypeDeclaration.class, (Object)12).put(FileTypeDeclaration.class, (Object)13).put(AnyTypeDeclaration.class, (Object)14).build();
    }

    public static List<TypeDeclaration> sortByPriority(List<TypeDeclaration> types) {
        LinkedList<TypeDeclaration> sortedTypes = new LinkedList<TypeDeclaration>(types);
        Map<Class<? extends TypeDeclaration>, Integer> typePriority = UnionTypesHelper.getPriorityTypeMap();
        Collections.sort(sortedTypes, (t1, t2) -> {
            if (t1 instanceof ObjectTypeDeclaration && t2 instanceof ObjectTypeDeclaration) {
                String d1 = ((ObjectTypeDeclaration)t1).discriminator();
                String d2 = ((ObjectTypeDeclaration)t2).discriminator();
                return d1 != null && d2 != null ? 0 : (d2 == null ? -1 : (d1 == null ? 1 : 0));
            }
            return Integer.compare((Integer)typePriority.get(Utils.declarationType(t1)), (Integer)typePriority.get(Utils.declarationType(t2)));
        });
        return sortedTypes;
    }

    public static boolean isAmbiguous(List<TypeDeclaration> typeDeclarations, Function<TypeDeclaration, TypeName> converter) {
        HashSet<TypeName> types = new HashSet<TypeName>();
        for (TypeDeclaration typeDeclaration : typeDeclarations) {
            if (types.add(converter.apply(typeDeclaration))) continue;
            return true;
        }
        return false;
    }
}

