/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.utils;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.GenerationException;
import org.raml.ramltopojo.extensions.utils.TypeCopyHandler;

public class DefaultTypeCopyHandler
implements TypeCopyHandler {
    @Override
    public TypeSpec.Builder newType(TypeSpec type) {
        TypeSpec.Builder newType;
        switch (type.kind) {
            case ANNOTATION: {
                newType = TypeSpec.annotationBuilder((String)type.name);
                break;
            }
            case ENUM: {
                newType = TypeSpec.enumBuilder((String)type.name);
                break;
            }
            case INTERFACE: {
                newType = TypeSpec.interfaceBuilder((String)type.name);
                break;
            }
            case CLASS: {
                newType = TypeSpec.classBuilder((String)type.name);
                break;
            }
            default: {
                throw new GenerationException("this can't happen...");
            }
        }
        return newType;
    }

    @Override
    public boolean handleAnnotations(TypeSpec.Builder newType, AnnotationSpec annotation) {
        newType.addAnnotation(annotation);
        return true;
    }

    @Override
    public boolean handleInitializerBlock(TypeSpec.Builder newType, CodeBlock initializerBlock) {
        newType.addInitializerBlock(initializerBlock);
        return true;
    }

    @Override
    public boolean handleStaticBlock(TypeSpec.Builder newType, CodeBlock staticBlock) {
        newType.addStaticBlock(staticBlock);
        return true;
    }

    @Override
    public boolean handleSuperclass(TypeSpec.Builder newType, TypeName superclass) {
        newType.superclass(superclass);
        return true;
    }

    @Override
    public boolean handleJavadoc(TypeSpec.Builder newType, CodeBlock javadoc) {
        newType.addJavadoc("$L", new Object[]{javadoc});
        return true;
    }

    @Override
    public boolean handleEnumConstant(TypeSpec.Builder newType, String key, TypeSpec value) {
        newType.addEnumConstant(key, value);
        return true;
    }

    @Override
    public boolean handleTypeSpec(TypeSpec.Builder newType, TypeSpec typeSpec) {
        newType.addType(typeSpec);
        return true;
    }

    @Override
    public boolean handleMethod(TypeSpec.Builder newType, MethodSpec methodSpec) {
        newType.addMethod(methodSpec);
        return true;
    }

    @Override
    public boolean handleField(TypeSpec.Builder newType, FieldSpec fieldSpec) {
        newType.addField(fieldSpec);
        return true;
    }

    @Override
    public boolean handleSuperInterface(TypeSpec.Builder newType, TypeName typeVariable) {
        newType.addSuperinterface(typeVariable);
        return true;
    }

    @Override
    public boolean handleTypeVariable(TypeSpec.Builder newType, TypeVariableName typeVariable) {
        newType.addTypeVariable(typeVariable);
        return true;
    }

    @Override
    public boolean handleModifier(TypeSpec.Builder newType, Modifier modifier) {
        newType.addModifiers(new Modifier[]{modifier});
        return true;
    }
}

