/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.tools;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.extensions.AllTypesPluginHelper;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.UnionPluginContext;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class AddEqualsAndHashCode
extends AllTypesPluginHelper {
    private final List<String> arguments;

    public AddEqualsAndHashCode(List<String> arguments) {
        this.arguments = arguments;
    }

    @Override
    public TypeSpec.Builder classCreated(ObjectPluginContext objectPluginContext, ObjectTypeDeclaration ramlType, TypeSpec.Builder incoming, EventType eventType) {
        if (eventType == EventType.IMPLEMENTATION) {
            ImmutableList specs = FluentIterable.from((Iterable)incoming.build().fieldSpecs).filter((Predicate)new Predicate<FieldSpec>(){

                public boolean apply(@Nullable FieldSpec input) {
                    if (AddEqualsAndHashCode.this.arguments.isEmpty()) {
                        return true;
                    }
                    return AddEqualsAndHashCode.this.arguments.contains(input.name);
                }
            }).toList();
            if (specs.isEmpty()) {
                return incoming;
            }
            this.createEquals((List<FieldSpec>)specs, incoming);
            this.createHashCode((List<FieldSpec>)specs, incoming);
            return incoming;
        }
        return super.classCreated(objectPluginContext, ramlType, incoming, eventType);
    }

    private void createHashCode(List<FieldSpec> specs, TypeSpec.Builder incoming) {
        String fields = FluentIterable.from(specs).transform((Function)new Function<FieldSpec, String>(){

            @Nullable
            public String apply(@Nullable FieldSpec fieldSpec) {
                return fieldSpec.name;
            }
        }).join(Joiner.on((String)","));
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(ClassName.get(Override.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.INT).addCode(CodeBlock.builder().addStatement("return $T.hash($L)", new Object[]{Objects.class, fields}).build());
        incoming.addMethod(method.build());
    }

    private List<CodeBlock> buildEquals(List<FieldSpec> fields) {
        return FluentIterable.from(fields).transform((Function)new Function<FieldSpec, CodeBlock>(){

            @Nullable
            public CodeBlock apply(@Nullable FieldSpec fieldSpec) {
                if (fieldSpec.type.isPrimitive()) {
                    return CodeBlock.builder().add("(this.$L == other.$L)", new Object[]{fieldSpec.name, fieldSpec.name}).build();
                }
                return CodeBlock.builder().add("$T.equals(this.$L, other.$L)", new Object[]{Objects.class, fieldSpec.name, fieldSpec.name}).build();
            }
        }).toList();
    }

    private void createEquals(List<FieldSpec> specs, TypeSpec.Builder incoming) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"equals").addAnnotation(ClassName.get(Override.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addParameter(ParameterSpec.builder((TypeName)ClassName.get(Object.class), (String)"o", (Modifier[])new Modifier[0]).build()).addCode(CodeBlock.builder().addStatement("if (o == null) return false", new Object[0]).addStatement("if (this == o) return true", new Object[0]).addStatement("if (getClass() != o.getClass()) return false", new Object[0]).addStatement("$L other = ($L) o", new Object[]{incoming.build().name, incoming.build().name}).addStatement(CodeBlock.builder().add("return ", new Object[0]).add(CodeBlock.join(this.buildEquals(specs), (String)" && ")).build()).build());
        incoming.addMethod(method.build());
    }

    @Override
    public TypeSpec.Builder classCreated(UnionPluginContext unionPluginContext, UnionTypeDeclaration ramlType, TypeSpec.Builder incoming, EventType eventType) {
        if (eventType != EventType.IMPLEMENTATION) {
            return incoming;
        }
        List specs = incoming.build().fieldSpecs;
        this.createEquals(specs, incoming);
        this.createHashCode(specs, incoming);
        return incoming;
    }
}

