/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.javadoc;

import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class JavadocObjectTypeHandlerPlugin
extends ObjectTypeHandlerPlugin.Helper {
    @Override
    public TypeSpec.Builder classCreated(ObjectPluginContext objectPluginContext, ObjectTypeDeclaration ramlType, final TypeSpec.Builder incoming, EventType eventType) {
        if (ramlType.description() != null) {
            incoming.addJavadoc("$L\n", new Object[]{ramlType.description().value()});
        }
        this.javadocExamples(new JavadocAdder(){

            @Override
            public void addJavadoc(String format, Object ... args) {
                incoming.addJavadoc(format, args);
            }
        }, (TypeDeclaration)ramlType);
        return incoming;
    }

    @Override
    public MethodSpec.Builder getterBuilt(ObjectPluginContext objectPluginContext, TypeDeclaration declaration, final MethodSpec.Builder incoming, EventType eventType) {
        if (declaration.description() != null) {
            incoming.addJavadoc("$L\n", new Object[]{declaration.description().value()});
        }
        this.javadocExamples(new JavadocAdder(){

            @Override
            public void addJavadoc(String format, Object ... args) {
                incoming.addJavadoc(format, args);
            }
        }, declaration);
        return incoming;
    }

    private void javadocExamples(JavadocAdder adder, TypeDeclaration typeDeclaration) {
        ExampleSpec example = typeDeclaration.example();
        if (example != null) {
            this.javadoc(adder, example);
        }
        for (ExampleSpec exampleSpec : typeDeclaration.examples()) {
            this.javadoc(adder, exampleSpec);
        }
    }

    private void javadoc(JavadocAdder adder, ExampleSpec exampleSpec) {
        adder.addJavadoc("Example:\n", new Object[0]);
        if (exampleSpec.name() != null) {
            adder.addJavadoc(" $L\n", exampleSpec.name());
        }
        adder.addJavadoc(" $L\n", "<pre>\n{@code\n" + exampleSpec.value() + "\n}</pre>");
    }

    private static interface JavadocAdder {
        public void addJavadoc(String var1, Object ... var2);
    }
}

