/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.jackson1;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.DateTimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class JacksonScalarTypeSerialization
extends ObjectTypeHandlerPlugin.Helper {
    @Override
    public FieldSpec.Builder fieldBuilt(ObjectPluginContext objectPluginContext, TypeDeclaration typeDeclaration, FieldSpec.Builder builder, EventType eventType) {
        if (typeDeclaration instanceof DateTimeOnlyTypeDeclaration) {
            builder.addAnnotation(AnnotationSpec.builder(JsonFormat.class).addMember("shape", "$T.STRING", new Object[]{JsonFormat.Shape.class}).addMember("pattern", "$S", new Object[]{"yyyy-MM-dd'T'HH:mm:ss"}).build());
        }
        if (typeDeclaration instanceof TimeOnlyTypeDeclaration) {
            builder.addAnnotation(AnnotationSpec.builder(JsonFormat.class).addMember("shape", "$T.STRING", new Object[]{JsonFormat.Shape.class}).addMember("pattern", "$S", new Object[]{"HH:mm:ss"}).build());
        }
        if (typeDeclaration instanceof DateTypeDeclaration) {
            builder.addAnnotation(AnnotationSpec.builder(JsonFormat.class).addMember("shape", "$T.STRING", new Object[]{JsonFormat.Shape.class}).addMember("pattern", "$S", new Object[]{"yyyy-MM-dd"}).build());
        }
        if (typeDeclaration instanceof DateTimeTypeDeclaration) {
            String format = ((DateTimeTypeDeclaration)typeDeclaration).format();
            if (format != null && "rfc2616".equals(format)) {
                builder.addAnnotation(AnnotationSpec.builder(JsonFormat.class).addMember("shape", "$T.STRING", new Object[]{JsonFormat.Shape.class}).addMember("pattern", "$S", new Object[]{"EEE, dd MMM yyyy HH:mm:ss z"}).build());
            } else {
                builder.addAnnotation(AnnotationSpec.builder(JsonFormat.class).addMember("shape", "$T.STRING", new Object[]{JsonFormat.Shape.class}).addMember("pattern", "$S", new Object[]{"yyyy-MM-dd'T'HH:mm:ssZ"}).build());
            }
        }
        return builder;
    }
}

