/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.constructor;

import com.google.common.base.Optional;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.EcmaPattern;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.Names;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class ConstructorExtension
extends ObjectTypeHandlerPlugin.Helper {
    @Override
    public TypeSpec.Builder classCreated(ObjectPluginContext objectPluginContext, ObjectTypeDeclaration ramlType, TypeSpec.Builder typeSpec, EventType eventType) {
        if (eventType != EventType.IMPLEMENTATION) {
            return typeSpec;
        }
        boolean hasConstructorParams = false;
        TypeSpec clazz = typeSpec.build();
        MethodSpec.Builder fullConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        Optional discriminator = Optional.fromNullable((Object)ramlType.discriminator());
        for (TypeDeclaration propertyDeclaration : ramlType.properties()) {
            if (EcmaPattern.isSlashedPattern(propertyDeclaration.name()) || Objects.equals(propertyDeclaration.name(), discriminator.orNull())) continue;
            fullConstructor.addCode(CodeBlock.builder().addStatement("this." + Names.variableName(propertyDeclaration.name()) + " = " + Names.variableName(propertyDeclaration.name()), new Object[0]).build()).addParameter(this.findField(clazz, propertyDeclaration), Names.variableName(propertyDeclaration.name()), new Modifier[0]);
            hasConstructorParams = true;
        }
        if (hasConstructorParams) {
            typeSpec.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
            typeSpec.addMethod(fullConstructor.build());
        }
        return typeSpec;
    }

    private TypeName findField(TypeSpec clazz, TypeDeclaration field) {
        for (FieldSpec fieldSpec : clazz.fieldSpecs) {
            if (!Objects.equals(field.name(), fieldSpec.name)) continue;
            return fieldSpec.type;
        }
        throw new IllegalArgumentException("There is no field of name: " + field.name());
    }
}

