/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.extensions.EnumerationPluginContext;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public interface EnumerationTypeHandlerPlugin {
    public ClassName className(EnumerationPluginContext var1, TypeDeclaration var2, ClassName var3, EventType var4);

    public TypeSpec.Builder classCreated(EnumerationPluginContext var1, TypeDeclaration var2, TypeSpec.Builder var3, EventType var4);

    public TypeSpec.Builder enumValue(EnumerationPluginContext var1, TypeDeclaration var2, TypeSpec.Builder var3, String var4, EventType var5);

    public TypeSpec.Builder enumValue(EnumerationPluginContext var1, TypeDeclaration var2, TypeSpec.Builder var3, Number var4, EventType var5);

    public static class Composite
    implements EnumerationTypeHandlerPlugin {
        private final List<EnumerationTypeHandlerPlugin> plugins = new ArrayList<EnumerationTypeHandlerPlugin>();

        public Composite(Set<EnumerationTypeHandlerPlugin> actualPlugins) {
            this.plugins.addAll(actualPlugins);
        }

        @Override
        public ClassName className(EnumerationPluginContext enumerationPluginContext, TypeDeclaration ramlType, ClassName currentSuggestion, EventType eventType) {
            for (EnumerationTypeHandlerPlugin plugin : this.plugins) {
                currentSuggestion = plugin.className(enumerationPluginContext, ramlType, currentSuggestion, eventType);
            }
            return currentSuggestion;
        }

        @Override
        public TypeSpec.Builder classCreated(EnumerationPluginContext enumerationPluginContext, TypeDeclaration ramlType, TypeSpec.Builder incoming, EventType eventType) {
            for (EnumerationTypeHandlerPlugin plugin : this.plugins) {
                if (incoming == null) break;
                incoming = plugin.classCreated(enumerationPluginContext, ramlType, incoming, eventType);
            }
            return incoming;
        }

        @Override
        public TypeSpec.Builder enumValue(EnumerationPluginContext enumerationPluginContext, TypeDeclaration declaration, TypeSpec.Builder incoming, String value, EventType eventType) {
            for (EnumerationTypeHandlerPlugin plugin : this.plugins) {
                if (incoming == null) break;
                incoming = plugin.enumValue(enumerationPluginContext, declaration, incoming, value, eventType);
            }
            return incoming;
        }

        @Override
        public TypeSpec.Builder enumValue(EnumerationPluginContext enumerationPluginContext, TypeDeclaration declaration, TypeSpec.Builder incoming, Number value, EventType eventType) {
            for (EnumerationTypeHandlerPlugin plugin : this.plugins) {
                if (incoming == null) break;
                incoming = plugin.enumValue(enumerationPluginContext, declaration, incoming, value, eventType);
            }
            return incoming;
        }
    }

    public static class Helper
    implements EnumerationTypeHandlerPlugin {
        @Override
        public ClassName className(EnumerationPluginContext enumerationPluginContext, TypeDeclaration ramlType, ClassName currentSuggestion, EventType eventType) {
            return currentSuggestion;
        }

        @Override
        public TypeSpec.Builder classCreated(EnumerationPluginContext enumerationPluginContext, TypeDeclaration ramlType, TypeSpec.Builder incoming, EventType eventType) {
            return incoming;
        }

        @Override
        public TypeSpec.Builder enumValue(EnumerationPluginContext enumerationPluginContext, TypeDeclaration declaration, TypeSpec.Builder incoming, String value, EventType eventType) {
            return incoming;
        }

        @Override
        public TypeSpec.Builder enumValue(EnumerationPluginContext enumerationPluginContext, TypeDeclaration declaration, TypeSpec.Builder incoming, Number value, EventType eventType) {
            return incoming;
        }
    }
}

