/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.enumeration;

import com.google.common.base.Optional;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.CreationResult;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.GenerationContext;
import org.raml.ramltopojo.Names;
import org.raml.ramltopojo.TypeHandler;
import org.raml.ramltopojo.Utils;
import org.raml.ramltopojo.extensions.EnumerationPluginContext;
import org.raml.ramltopojo.extensions.EnumerationPluginContextImpl;
import org.raml.v2.api.model.v10.datamodel.IntegerTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class EnumerationTypeHandler
implements TypeHandler {
    private final String name;
    private final TypeDeclaration typeDeclaration;

    public EnumerationTypeHandler(String name, TypeDeclaration stringTypeDeclaration) {
        this.name = name;
        this.typeDeclaration = stringTypeDeclaration;
    }

    @Override
    public ClassName javaClassName(GenerationContext generationContext, EventType type) {
        EnumerationPluginContextImpl enumerationPluginContext = new EnumerationPluginContextImpl(generationContext, null);
        return generationContext.pluginsForEnumerations(Utils.allParents(this.typeDeclaration, new ArrayList<TypeDeclaration>()).toArray(new TypeDeclaration[0])).className(enumerationPluginContext, this.typeDeclaration, generationContext.buildDefaultClassName(Names.typeName(this.name), EventType.INTERFACE), EventType.INTERFACE);
    }

    @Override
    public TypeName javaClassReference(GenerationContext generationContext, EventType type) {
        return this.javaClassName(generationContext, type);
    }

    @Override
    public Optional<CreationResult> create(GenerationContext generationContext, CreationResult preCreationResult) {
        Class cls = this.typeDeclaration instanceof StringTypeDeclaration ? String.class : Number.class;
        FieldSpec.Builder field = FieldSpec.builder((TypeName)ClassName.get(cls), (String)"name", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL});
        EnumerationPluginContextImpl enumerationPluginContext = new EnumerationPluginContextImpl(generationContext, preCreationResult);
        ClassName className = preCreationResult.getJavaName(EventType.INTERFACE);
        TypeSpec.Builder enumBuilder = TypeSpec.enumBuilder((ClassName)className);
        enumBuilder.addField(field.build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)ClassName.get(cls), "name", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"name", "name"}).build());
        enumBuilder = generationContext.pluginsForEnumerations(this.typeDeclaration).classCreated(enumerationPluginContext, this.typeDeclaration, enumBuilder, EventType.INTERFACE);
        if (enumBuilder == null) {
            return Optional.absent();
        }
        for (Object value : this.pullEnumValues(this.typeDeclaration)) {
            TypeSpec.Builder enumValueBuilder;
            if (value instanceof String) {
                enumValueBuilder = TypeSpec.anonymousClassBuilder((String)"$S", (Object[])new Object[]{value});
                enumValueBuilder = generationContext.pluginsForEnumerations(this.typeDeclaration).enumValue((EnumerationPluginContext)enumerationPluginContext, this.typeDeclaration, enumValueBuilder, (String)value, EventType.INTERFACE);
            } else {
                enumValueBuilder = TypeSpec.anonymousClassBuilder((String)"$L", (Object[])new Object[]{value});
                enumValueBuilder = generationContext.pluginsForEnumerations(this.typeDeclaration).enumValue((EnumerationPluginContext)enumerationPluginContext, this.typeDeclaration, enumValueBuilder, (Number)value, EventType.INTERFACE);
            }
            if (enumValueBuilder == null) continue;
            enumBuilder.addEnumConstant(Names.constantName(String.valueOf(value)), enumValueBuilder.build());
        }
        return Optional.of((Object)preCreationResult.withInterface(enumBuilder.build()));
    }

    List pullEnumValues(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof IntegerTypeDeclaration) {
            return ((IntegerTypeDeclaration)typeDeclaration).enumValues();
        }
        if (typeDeclaration instanceof NumberTypeDeclaration) {
            return ((NumberTypeDeclaration)typeDeclaration).enumValues();
        }
        return ((StringTypeDeclaration)typeDeclaration).enumValues();
    }
}

