/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.raml.ramltopojo.NameFixer;
import org.raml.v2.api.model.v08.bodies.BodyLike;
import org.raml.v2.api.model.v08.methods.Method;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.resources.Resource;

public class Names {
    private static Pattern LEADING_UNDERSCORES = Pattern.compile("^_+");

    public static String typeName(String ... name) {
        if (name.length == 1 && StringUtils.isBlank((String)name[0])) {
            return "Root";
        }
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        for (String s : name) {
            String value = Names.buildPart(i, s, NameFixer.CAMEL_UPPER);
            values.add(value);
            ++i;
        }
        return Joiner.on((String)"").join(values);
    }

    public static String methodName(String ... name) {
        return Names.checkMethodName(Names.smallCamel(name));
    }

    private static String checkMethodName(String s) {
        if ("getClass".equals(s)) {
            return "getClazz";
        }
        if ("setClass".equals(s)) {
            return "setClazz";
        }
        return s;
    }

    private static String smallCamel(String ... name) {
        if (name.length == 1 && StringUtils.isBlank((String)name[0])) {
            return "root";
        }
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < name.length; ++i) {
            String s = name[i];
            NameFixer format = NameFixer.CAMEL_LOWER;
            values.add(Names.buildPart(i, s, format));
        }
        return Joiner.on((String)"").join(values);
    }

    public static String variableName(String ... name) {
        Matcher m = LEADING_UNDERSCORES.matcher(name[0]);
        if (m.find()) {
            return m.group() + Names.smallCamel(name);
        }
        return Names.checkForReservedWord(Names.smallCamel(name));
    }

    private static String checkForReservedWord(String name) {
        if (SourceVersion.isKeyword(name)) {
            return name + "Variable";
        }
        return name;
    }

    public static String constantName(String value) {
        return Names.buildJavaFriendlyName(value, NameFixer.ALL_UPPER, 0);
    }

    public static String enumName(String value) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Names.buildJavaFriendlyName(value, NameFixer.CAMEL_UPPER, 0));
    }

    public static String javaTypeName(Resource resource, TypeDeclaration declaration) {
        return Names.typeName(resource.resourcePath(), declaration.name());
    }

    public static String javaTypeName(Resource resource, org.raml.v2.api.model.v10.methods.Method method, TypeDeclaration declaration) {
        return Names.typeName(resource.resourcePath(), method.method(), declaration.name());
    }

    public static String ramlTypeName(Resource resource, org.raml.v2.api.model.v10.methods.Method method, TypeDeclaration declaration) {
        return resource.resourcePath() + method.method() + declaration.name();
    }

    public static String ramlTypeName(Resource resource, TypeDeclaration declaration) {
        return resource.resourcePath() + declaration.name();
    }

    public static String javaTypeName(Resource resource, org.raml.v2.api.model.v10.methods.Method method, Response response, TypeDeclaration declaration) {
        return Names.typeName(resource.resourcePath(), method.method(), response.code().value(), declaration.name());
    }

    public static String ramlTypeName(Resource resource, org.raml.v2.api.model.v10.methods.Method method, Response response, TypeDeclaration declaration) {
        return resource.resourcePath() + method.method() + response.code().value() + declaration.name();
    }

    private Names() {
        throw new UnsupportedOperationException();
    }

    private static String buildJavaFriendlyName(String source, NameFixer format, int currentIndex) {
        String baseName = source.replaceAll("\\W+", "_").replaceAll("^_+", "").replaceAll("[^\\w_]", "");
        ArrayList<String> friendlyNameBits = new ArrayList<String>();
        int i = currentIndex;
        for (String s : baseName.split("_")) {
            if (s.isEmpty()) continue;
            String friendlyName = Names.firstOrOthers(format, i, s);
            if (NumberUtils.isDigits((String)StringUtils.left((String)friendlyName, (int)1))) {
                friendlyName = "_" + friendlyName;
            }
            friendlyNameBits.add(friendlyName);
            ++i;
        }
        return Joiner.on((String)"").join(friendlyNameBits);
    }

    private static String buildPart(int i, String s, NameFixer format) {
        if (i == 0) {
            s = s.replaceAll("^.*\\.", "");
        }
        String part = s.matches(".*[^a-zA-Z0-9].*") ? Names.buildJavaFriendlyName(s, format, i) : Names.firstOrOthers(format, i, s);
        return part;
    }

    private static String firstOrOthers(NameFixer format, int i, String s) {
        if (i == 0) {
            return format.fixFirst(s);
        }
        return format.fixOthers(s);
    }

    public static String ramlTypeName(org.raml.v2.api.model.v08.resources.Resource resource, Method method, BodyLike typeDeclaration) {
        return resource.resourcePath() + method.method() + typeDeclaration.name();
    }

    public static String ramlTypeName(org.raml.v2.api.model.v08.resources.Resource resource, Method method, org.raml.v2.api.model.v08.bodies.Response response, BodyLike typeDeclaration) {
        return resource.resourcePath() + method.method() + response.code().value() + typeDeclaration.name();
    }

    public static String javaTypeName(org.raml.v2.api.model.v08.resources.Resource resource, Method method, BodyLike typeDeclaration) {
        return Names.typeName(resource.resourcePath(), method.method(), typeDeclaration.name());
    }

    public static String javaTypeName(org.raml.v2.api.model.v08.resources.Resource resource, Method method, org.raml.v2.api.model.v08.bodies.Response response, BodyLike typeDeclaration) {
        return Names.typeName(resource.resourcePath(), method.method(), response.code().value(), typeDeclaration.name());
    }
}

