/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMinInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaPatternFacet;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;
import org.raml.v2.internal.impl.commons.type.JsonSchemaExternalType;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.XmlSchemaExternalType;
import org.raml.v2.internal.impl.v10.type.AnyResolvedType;
import org.raml.v2.internal.impl.v10.type.ArrayResolvedType;
import org.raml.v2.internal.impl.v10.type.BooleanResolvedType;
import org.raml.v2.internal.impl.v10.type.DateOnlyResolvedType;
import org.raml.v2.internal.impl.v10.type.DateTimeOnlyResolvedType;
import org.raml.v2.internal.impl.v10.type.DateTimeResolvedType;
import org.raml.v2.internal.impl.v10.type.FileResolvedType;
import org.raml.v2.internal.impl.v10.type.IntegerResolvedType;
import org.raml.v2.internal.impl.v10.type.NullResolvedType;
import org.raml.v2.internal.impl.v10.type.NumberResolvedType;
import org.raml.v2.internal.impl.v10.type.ObjectResolvedType;
import org.raml.v2.internal.impl.v10.type.PropertyFacets;
import org.raml.v2.internal.impl.v10.type.StringResolvedType;
import org.raml.v2.internal.impl.v10.type.TimeOnlyResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.UnionResolvedType;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.v2.internal.utils.ValueUtils;

public class TypeToSchemaVisitor
implements TypeVisitor<XmlSchemaType> {
    public static final long UNBOUNDED = Long.MAX_VALUE;
    private XmlSchemaCollection collection = new XmlSchemaCollection();
    private XmlSchema schema = new XmlSchema("http://www.w3.org/2001/XMLSchema", "raml-xsd", this.collection);
    private Stack<XmlSchemaElement> currentElement = new Stack();
    private Map<String, XmlSchemaType> types = new HashMap<String, XmlSchemaType>();

    public XmlSchema getSchema() {
        return this.schema;
    }

    public XmlSchemaElement transform(String name, ResolvedType resolvedType) {
        boolean empty = this.currentElement.isEmpty();
        if (empty && resolvedType instanceof XmlFacetsCapableType && ((XmlFacetsCapableType)resolvedType).getXmlFacets().getNamespace() != null) {
            this.schema.setTargetNamespace(((XmlFacetsCapableType)resolvedType).getXmlFacets().getNamespace());
        }
        XmlSchemaElement schemaElement = new XmlSchemaElement(this.schema, empty);
        schemaElement.setName(name);
        this.currentElement.push(schemaElement);
        XmlSchemaType visit = resolvedType.visit(this);
        if (visit != null) {
            if (visit.getQName() != null) {
                schemaElement.setSchemaTypeName(visit.getQName());
            } else {
                schemaElement.setSchemaType(visit);
            }
        }
        this.currentElement.pop();
        return schemaElement;
    }

    @Override
    public XmlSchemaType visitString(StringResolvedType stringTypeDefinition) {
        List<String> enums;
        XmlSchemaSimpleType simpleType = new XmlSchemaSimpleType(this.schema, false);
        XmlSchemaSimpleTypeRestriction content = new XmlSchemaSimpleTypeRestriction();
        content.setBaseTypeName(Constants.XSD_STRING);
        if (stringTypeDefinition.getMinLength() != null) {
            XmlSchemaMinLengthFacet minLength = new XmlSchemaMinLengthFacet();
            minLength.setValue((Object)stringTypeDefinition.getMinLength());
            content.getFacets().add(minLength);
        }
        if (stringTypeDefinition.getMaxLength() != null) {
            XmlSchemaMaxLengthFacet maxLength = new XmlSchemaMaxLengthFacet();
            maxLength.setValue((Object)stringTypeDefinition.getMaxLength());
            content.getFacets().add(maxLength);
        }
        if (!ValueUtils.isEmpty(enums = stringTypeDefinition.getEnums())) {
            for (String anEnum : enums) {
                XmlSchemaEnumerationFacet enumValue = new XmlSchemaEnumerationFacet();
                enumValue.setValue((Object)anEnum);
                content.getFacets().add(enumValue);
            }
        }
        if (stringTypeDefinition.getPattern() != null) {
            XmlSchemaPatternFacet patternFacet = new XmlSchemaPatternFacet();
            patternFacet.setValue((Object)stringTypeDefinition.getPattern());
            content.getFacets().add(patternFacet);
        }
        simpleType.setContent((XmlSchemaSimpleTypeContent)content);
        return simpleType;
    }

    @Override
    public XmlSchemaType visitObject(ObjectResolvedType objectTypeDefinition) {
        String typeName = objectTypeDefinition.getTypeName();
        if (typeName != null && this.types.containsKey(typeName)) {
            return this.types.get(typeName);
        }
        XmlSchemaComplexType value = new XmlSchemaComplexType(this.schema, typeName != null);
        if (typeName != null) {
            value.setName(typeName);
            this.types.put(typeName, (XmlSchemaType)value);
        }
        XmlSchemaChoice xmlSchemaSequence = new XmlSchemaChoice();
        List items = xmlSchemaSequence.getItems();
        value.setParticle((XmlSchemaParticle)xmlSchemaSequence);
        Map<String, PropertyFacets> properties = objectTypeDefinition.getProperties();
        for (PropertyFacets propertyDefinition : properties.values()) {
            ResolvedType valueResolvedType = propertyDefinition.getValueType();
            if (!(valueResolvedType instanceof XmlFacetsCapableType)) continue;
            XmlFacets xmlFacets = ((XmlFacetsCapableType)valueResolvedType).getXmlFacets();
            String name = ValueUtils.defaultTo(xmlFacets.getName(), propertyDefinition.getName());
            if (ValueUtils.asBoolean(xmlFacets.getAttribute(), false)) {
                XmlSchemaAttribute xmlSchemaAttribute = new XmlSchemaAttribute(this.schema, false);
                xmlSchemaAttribute.setName(name);
                XmlSchemaType visit = valueResolvedType.visit(this);
                if (visit instanceof XmlSchemaSimpleType) {
                    if (visit.getQName() != null) {
                        xmlSchemaAttribute.setSchemaTypeName(visit.getQName());
                    } else {
                        xmlSchemaAttribute.setSchemaType((XmlSchemaSimpleType)visit);
                    }
                }
                value.getAttributes().add(xmlSchemaAttribute);
                continue;
            }
            XmlSchemaElement schemaElement = this.transform(name, valueResolvedType);
            if (!propertyDefinition.isRequired()) {
                schemaElement.setMinOccurs(0L);
            }
            items.add(schemaElement);
        }
        if (ValueUtils.asBoolean(objectTypeDefinition.getAdditionalProperties(), true)) {
            XmlSchemaAny schemaAny = new XmlSchemaAny();
            schemaAny.setMinOccurs(0L);
            schemaAny.setMaxOccurs(Long.MAX_VALUE);
            items.add(schemaAny);
        }
        return value;
    }

    @Override
    public XmlSchemaType visitBoolean(BooleanResolvedType booleanTypeDefinition) {
        return this.collection.getTypeByQName(Constants.XSD_DECIMAL);
    }

    @Override
    public XmlSchemaType visitInteger(IntegerResolvedType integerTypeDefinition) {
        return this.createNumberSchemaType(integerTypeDefinition, Constants.XSD_INTEGER);
    }

    @Override
    public XmlSchemaType visitNumber(NumberResolvedType numberTypeDefinition) {
        return this.createNumberSchemaType(numberTypeDefinition, Constants.XSD_DOUBLE);
    }

    @Nonnull
    protected XmlSchemaType createNumberSchemaType(NumberResolvedType numberTypeDefinition, QName baseType) {
        XmlSchemaSimpleType simpleType = new XmlSchemaSimpleType(this.schema, false);
        XmlSchemaSimpleTypeRestriction content = new XmlSchemaSimpleTypeRestriction();
        content.setBaseTypeName(baseType);
        if (numberTypeDefinition.getMinimum() != null) {
            XmlSchemaMinInclusiveFacet minLength = new XmlSchemaMinInclusiveFacet();
            minLength.setValue((Object)numberTypeDefinition.getMinimum());
            content.getFacets().add(minLength);
        }
        if (numberTypeDefinition.getMaximum() != null) {
            XmlSchemaMaxInclusiveFacet maxLength = new XmlSchemaMaxInclusiveFacet();
            maxLength.setValue((Object)numberTypeDefinition.getMaximum());
            content.getFacets().add(maxLength);
        }
        simpleType.setContent((XmlSchemaSimpleTypeContent)content);
        return simpleType;
    }

    @Override
    public XmlSchemaType visitDateTimeOnly(DateTimeOnlyResolvedType dateTimeOnlyTypeDefinition) {
        return this.collection.getTypeByQName(Constants.XSD_DATETIME);
    }

    @Override
    public XmlSchemaType visitDate(DateOnlyResolvedType dateOnlyTypeDefinition) {
        return this.collection.getTypeByQName(Constants.XSD_DATE);
    }

    @Override
    public XmlSchemaType visitDateTime(DateTimeResolvedType dateTimeTypeDefinition) {
        return this.collection.getTypeByQName(Constants.XSD_DATETIME);
    }

    @Override
    public XmlSchemaType visitFile(FileResolvedType fileTypeDefinition) {
        return this.collection.getTypeByQName(Constants.XSD_BASE64);
    }

    @Override
    public XmlSchemaType visitNull(NullResolvedType nullTypeDefinition) {
        this.currentElement.peek().setNillable(true);
        return this.collection.getTypeByQName(Constants.XSD_ANY);
    }

    @Override
    public XmlSchemaType visitArray(ArrayResolvedType arrayTypeDefinition) {
        XmlSchemaType visit;
        ResolvedType itemType = arrayTypeDefinition.getItems();
        XmlFacets xmlFacets = arrayTypeDefinition.getXmlFacets();
        if (ValueUtils.asBoolean(xmlFacets.getWrapped(), false)) {
            String name = ValueUtils.defaultTo(ValueUtils.defaultTo(((XmlFacetsCapableType)itemType).getXmlFacets().getName(), itemType.getTypeName()), this.currentElement.peek().getName());
            XmlSchemaElement transform = this.transform(name, itemType);
            XmlSchemaComplexType value = new XmlSchemaComplexType(this.schema, false);
            XmlSchemaChoice xmlSchemaSequence = new XmlSchemaChoice();
            value.setParticle((XmlSchemaParticle)xmlSchemaSequence);
            xmlSchemaSequence.getItems().add(transform);
            visit = value;
        } else {
            visit = itemType.visit(this);
        }
        XmlSchemaElement peek = this.currentElement.peek();
        if (arrayTypeDefinition.getMinItems() != null) {
            peek.setMinOccurs((long)arrayTypeDefinition.getMinItems().intValue());
        }
        if (arrayTypeDefinition.getMaxItems() != null) {
            peek.setMaxOccurs((long)arrayTypeDefinition.getMaxItems().intValue());
        } else {
            peek.setMaxOccurs(Long.MAX_VALUE);
        }
        return visit;
    }

    @Override
    public XmlSchemaType visitUnion(UnionResolvedType unionTypeDefinition) {
        return unionTypeDefinition.of().get(0).visit(this);
    }

    @Override
    public XmlSchemaType visitTimeOnly(TimeOnlyResolvedType timeOnlyTypeDefinition) {
        return this.collection.getTypeByQName(Constants.XSD_TIME);
    }

    @Override
    public XmlSchemaType visitJson(JsonSchemaExternalType jsonTypeDefinition) {
        return this.createAny();
    }

    @Override
    public XmlSchemaType visitXml(XmlSchemaExternalType xmlTypeDefinition) {
        return this.createAny();
    }

    @Override
    public XmlSchemaType visitAny(AnyResolvedType anyResolvedType) {
        return this.createAny();
    }

    @Nonnull
    private XmlSchemaType createAny() {
        XmlSchemaComplexType value = new XmlSchemaComplexType(this.schema, false);
        XmlSchemaChoice xmlSchemaSequence = new XmlSchemaChoice();
        value.setParticle((XmlSchemaParticle)xmlSchemaSequence);
        List items = xmlSchemaSequence.getItems();
        XmlSchemaAny schemaAny = new XmlSchemaAny();
        schemaAny.setMinOccurs(0L);
        schemaAny.setMaxOccurs(Long.MAX_VALUE);
        items.add(schemaAny);
        return value;
    }
}

