/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.rules;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.suggester.ReferenceSuggester;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.DefaultSuggestion;
import org.raml.yagi.framework.suggester.RamlParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class TypeExpressionReferenceRule
extends Rule {
    private ReferenceSuggester suggester = new ReferenceSuggester("types");

    public boolean matches(@Nonnull Node node) {
        return node instanceof StringNode || node instanceof TypeExpressionNode;
    }

    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (node instanceof TypeExpressionNode) {
            return node;
        }
        return this.createNodeUsingFactory(node, new Object[]{((StringNode)node).getLiteralValue()});
    }

    public String getDescription() {
        return "Type reference expression.";
    }

    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        TypeId[] values;
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>(this.suggester.getSuggestions(node));
        for (TypeId value : values = TypeId.values()) {
            suggestions.add((Suggestion)new DefaultSuggestion(value.getType(), "", StringUtils.capitalize((String)value.getType())));
        }
        return suggestions;
    }
}

