/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.phase;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.ws.commons.schema.XmlSchema;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.nodes.ExampleDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.type.JsonSchemaExternalType;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.XmlSchemaExternalType;
import org.raml.v2.internal.impl.v10.type.AnyResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeToRuleVisitor;
import org.raml.v2.internal.impl.v10.type.TypeToSchemaVisitor;
import org.raml.v2.internal.utils.ValueUtils;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.nodes.snakeyaml.RamlNodeParser;
import org.raml.yagi.framework.phase.Phase;
import org.raml.yagi.framework.util.NodeUtils;
import org.xml.sax.SAXException;

public class ExampleValidationPhase
implements Phase {
    private ResourceLoader resourceLoader;

    public ExampleValidationPhase(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Node apply(Node tree) {
        List descendantsWith = tree.findDescendantsWith(ExampleDeclarationNode.class);
        for (ExampleDeclarationNode exampleTypeNode : descendantsWith) {
            Node validate;
            if (exampleTypeNode.isStrict().booleanValue()) continue;
            TypeDeclarationNode type = (TypeDeclarationNode)NodeUtils.getAncestor((Node)exampleTypeNode, TypeDeclarationNode.class);
            Node exampleValue = exampleTypeNode.getExampleValue();
            if (type == null || (validate = this.validate(type, exampleValue)) == null) continue;
            exampleValue.replaceWith(validate);
        }
        return tree;
    }

    @Nullable
    public Node validate(TypeDeclarationNode type, Node exampleValue) {
        ResolvedType resolvedType = type.getResolvedType();
        if (resolvedType instanceof AnyResolvedType) {
            return null;
        }
        if (exampleValue instanceof StringNode && !this.isExternalSchemaType(resolvedType)) {
            String value = ((StringNode)exampleValue).getValue();
            if (this.isXmlValue(value)) {
                return this.validateXml(type, resolvedType, value);
            }
            if (this.isJsonValue(value)) {
                return this.validateJson(exampleValue, resolvedType, value);
            }
            Rule rule = resolvedType.visit(new TypeToRuleVisitor(this.resourceLoader));
            return rule.apply(exampleValue);
        }
        if (exampleValue != null) {
            Rule rule = resolvedType.visit(new TypeToRuleVisitor(this.resourceLoader));
            return rule.apply(exampleValue);
        }
        return null;
    }

    protected Node validateJson(Node exampleValue, ResolvedType resolvedType, String value) {
        Rule rule = resolvedType.visit(new TypeToRuleVisitor(this.resourceLoader));
        Node parse = RamlNodeParser.parse((ResourceLoader)this.resourceLoader, (String)"", (String)value);
        Node apply = rule.apply(parse);
        List errorNodeList = apply.findDescendantsWith(ErrorNode.class);
        if (apply instanceof ErrorNode || !errorNodeList.isEmpty()) {
            String errorMessage = "";
            if (apply instanceof ErrorNode) {
                errorMessage = errorMessage + "- " + ((ErrorNode)apply).getErrorMessage();
            }
            for (ErrorNode errorNode : errorNodeList) {
                if (errorMessage.isEmpty()) {
                    errorMessage = "- " + errorNode.getErrorMessage();
                    continue;
                }
                errorMessage = errorMessage + "\n- " + errorNode.getErrorMessage();
            }
            return ErrorNodeFactory.createInvalidJsonExampleNode((String)errorMessage);
        }
        return exampleValue;
    }

    @Nullable
    protected Node validateXml(TypeDeclarationNode type, ResolvedType resolvedType, String value) {
        TypeToSchemaVisitor typeToSchemaVisitor = new TypeToSchemaVisitor();
        typeToSchemaVisitor.transform(ValueUtils.defaultTo(type.getTypeName(), "raml-root"), resolvedType);
        XmlSchema schema = typeToSchemaVisitor.getSchema();
        StringWriter xsd = new StringWriter();
        schema.write((Writer)xsd);
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Validator validator = factory.newSchema(new StreamSource(new StringReader(xsd.toString()))).newValidator();
            validator.validate(new StreamSource(new StringReader(value)));
        }
        catch (IOException | SAXException e) {
            return ErrorNodeFactory.createInvalidXmlExampleNode((String)e.getMessage());
        }
        return null;
    }

    private boolean isXmlValue(String value) {
        return value.trim().startsWith("<");
    }

    private boolean isJsonValue(String value) {
        return value.trim().startsWith("{") || value.trim().startsWith("[");
    }

    private boolean isExternalSchemaType(ResolvedType resolvedType) {
        return resolvedType instanceof XmlSchemaExternalType || resolvedType instanceof JsonSchemaExternalType;
    }
}

