/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.impl.commons.RamlVersion;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.internal.impl.v08.Raml08Builder;
import org.raml.v2.internal.impl.v10.Raml10Builder;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.nodes.EmptyErrorNode;
import org.raml.yagi.framework.nodes.Node;

public class RamlBuilder {
    public static int FIRST_PHASE = 1;
    public static int GRAMMAR_PHASE = 3;
    public static int ALL_PHASES = Integer.MAX_VALUE;
    private int maxPhaseNumber;
    private ResourceLoader resourceLoader = null;
    private String actualPath = null;

    public RamlBuilder() {
        this.maxPhaseNumber = ALL_PHASES;
    }

    public RamlBuilder(int maxPhaseNumber) {
        this.maxPhaseNumber = maxPhaseNumber;
    }

    public Node build(File ramlFile) {
        return this.build(ramlFile, (ResourceLoader)new DefaultResourceLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node build(File ramlFile, ResourceLoader resourceLoader) {
        this.resourceLoader = new CompositeResourceLoader(new ResourceLoader[]{resourceLoader, new FileResourceLoader(ramlFile.getParent())});
        this.actualPath = ramlFile.getPath();
        try (FileReader reader = new FileReader(ramlFile);){
            Node node = this.build(reader, this.resourceLoader, ramlFile.getName());
            return node;
        }
        catch (IOException ioe) {
            return ErrorNodeFactory.createInvalidInput((IOException)ioe);
        }
    }

    public Node build(String content) {
        return this.build(content, "");
    }

    public Node build(String content, String resourceLocation) {
        return this.build(content, (ResourceLoader)new DefaultResourceLoader(), resourceLocation);
    }

    public Node build(String content, ResourceLoader resourceLoader, String resourceLocation) {
        return this.build(new StringReader(content), resourceLoader, resourceLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node build(Reader content, ResourceLoader resourceLoader, String resourceLocation) {
        try {
            String stringContent = IOUtils.toString((Reader)content);
            RamlHeader ramlHeader = RamlHeader.parse(stringContent);
            Node result = RamlVersion.RAML_10 == ramlHeader.getVersion() ? new Raml10Builder().build(stringContent, ramlHeader.getFragment(), resourceLoader, resourceLocation, this.maxPhaseNumber) : new Raml08Builder().build(stringContent, resourceLoader, resourceLocation, this.maxPhaseNumber);
            if (result instanceof RamlDocumentNode) {
                ((RamlDocumentNode)result).setVersion(ramlHeader.getVersion());
            }
            Node node = result;
            return node;
        }
        catch (IOException ioe) {
            Node node = ErrorNodeFactory.createInvalidInput((IOException)ioe);
            return node;
        }
        catch (RamlHeader.InvalidHeaderVersionException e) {
            Node node = ErrorNodeFactory.createUnsupportedVersion((String)e.getMessage());
            return node;
        }
        catch (RamlHeader.InvalidHeaderFragmentException e) {
            Node node = ErrorNodeFactory.createInvalidFragmentName((String)e.getMessage());
            return node;
        }
        catch (RamlHeader.MissingHeaderException e) {
            EmptyErrorNode emptyErrorNode = ErrorNodeFactory.createEmptyDocument();
            return emptyErrorNode;
        }
        catch (RamlHeader.InvalidHeaderException e) {
            Node node = ErrorNodeFactory.createInvalidHeader((String)e.getMessage());
            return node;
        }
        finally {
            IOUtils.closeQuietly((Reader)content);
        }
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String getActualPath() {
        return this.actualPath;
    }
}

